(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    363515,       8168]
NotebookOptionsPosition[    328976,       7696]
NotebookOutlinePosition[    329369,       7712]
CellTagsIndexPosition[    329326,       7709]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"8649fc87-1c15-4bf9-9237-6c8c3a8bdb46"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967829567188303*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"1c7ac391-3e80-48fb-a7a1-756196bac0d3"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967829592911233*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"ff26a3ca-986d-4a3c-a8a5-a53b77f763d4"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.96782959291197*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"9c2cf494-86dd-4526-b340-92d81792d6ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.9678295929123173`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"5febd24b-9091-4e35-8984-e0f588f6f5dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967829592912663*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"8b4bb031-4b0a-4456-bc5e-6f1fee87e2e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.9678295929129887`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"0abcff7a-7d3b-4562-8ed3-991039b186a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9, 3.967829592913291*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"cc12b55c-9db7-429a-ab35-c1219d0b24ba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["14. CreateTikZAnimation", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966529948809907*^9, 3.966529956215705*^9}, {
   3.966531029355278*^9, 3.9665310324940443`*^9}, {3.9678292362201157`*^9, 
   3.967829243123782*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "CreateTikZAnimation"}]], "Input",
 CellChangeTimes->{{3.9675372979547977`*^9, 3.9675373029895287`*^9}, 
   3.967829246977078*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"b56a2495-e5bc-de40-81a5-bea435140357"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"CreateTikZAnimation[plotFunc, paramSpecs, fileName] \
crea una animaci\[OAcute]n LaTeX usando el paquete 'animate' a partir de una \
funci\[OAcute]n pura de Mathematica que genera gr\[AAcute]ficos.\\n\\nPAR\
\[CapitalAAcute]METROS:\\nplotFunc: Function pura que genera objetos \
Graphics. Debe usar la sintaxis Function[{var1, var2, ...}, \
expresi\[OAcute]n] o expresi\[OAcute]n & para un \
par\[AAcute]metro.\\nparamSpecs: Lista de especificaciones de \
par\[AAcute]metros en formato {{var, min, max}, ...} para par\[AAcute]metros \
continuos o {{var, {val1, val2, ...}}, ...} para par\[AAcute]metros \
discretos.\\nfileName: String con el nombre del archivo .tex de salida (debe \
incluir extensi\[OAcute]n .tex).\\nOPCIONES:\\nnumFrames: Entero entre 2 y \
200 que especifica el n\[UAcute]mero de frames de la animaci\[OAcute]n \
(default: 20).\\nframeRate: N\[UAcute]mero entre 0 y 60 que especifica los \
frames por segundo (default: 5).\\ngridOption: True/False para \
mostrar/ocultar la cuadr\[IAcute]cula en el gr\[AAcute]fico (default: \
True).\\nstylesOption: String con el color de las l\[IAcute]neas. Valores v\
\[AAcute]lidos: \\\"red\\\", \\\"blue\\\", \\\"green\\\", \\\"orange\\\", \
\\\"purple\\\", \\\"black\\\" (default: \\\"black\\\").\\naxesOption: \
True/False para mostrar/ocultar los ejes del gr\[AAcute]fico (default: True).\
\\nxmin: N\[UAcute]mero que especifica el valor m\[IAcute]nimo del eje X \
(default: Automatic - se calcula autom\[AAcute]ticamente).\\nxmax: \
N\[UAcute]mero que especifica el valor m\[AAcute]ximo del eje X (default: \
Automatic - se calcula autom\[AAcute]ticamente).\\nymin: N\[UAcute]mero que \
especifica el valor m\[IAcute]nimo del eje Y (default: Automatic - se calcula \
autom\[AAcute]ticamente).\\nymax: N\[UAcute]mero que especifica el valor m\
\[AAcute]ximo del eje Y (default: Automatic - se calcula \
autom\[AAcute]ticamente).\\npoints: True/False para mostrar puntos discretos \
en lugar de l\[IAcute]neas continuas. Cuando es True, las l\[IAcute]neas se \
muestran como puntos circulares rellenos (default: False).\\nVALOR DE \
RETORNO:\\nString con la ruta completa del archivo .tex generado, o \
\\\\$Failed si hay errores.\\nEJEMPLOS:\\nCreateTikZAnimation[Function[{a}, \
Plot[Sin[a*x], {x, 0, 2\[Pi]}]], {{a, 1, 5}}, \
\\\"seno.tex\\\"]\\nCreateTikZAnimation[Plot[Sin[#*x], {x, 0, 2\[Pi]}] &, \
{{a, 1, 5}}, \\\"seno.tex\\\", 30, 8, True, \\\"blue\\\", True, 0, 2\[Pi], \
-1.5, 1.5]\\nCreateTikZAnimation[Function[{a, b}, Plot[a*Sin[b*x], {x, 0, 2\
\[Pi]}]], {{a, 0.5, 2}, {b, 1, 4}}, \
\\\"complejo.tex\\\"]\\nCreateTikZAnimation[Function[{amp}, \
ListPlot[Table[{x, amp*Sin[x]}, {x, 0, 6, 0.2}], Joined -> True]], {{amp, \
0.5, 2}}, \\\"puntos.tex\\\", points -> True]\\nCOMPATIBILIDAD:\\nFunciona \
con Plot, ParametricPlot, PolarPlot, ListLinePlot, ListPlot, LogPlot y \
cualquier funci\[OAcute]n que genere primitivas Line dentro de objetos \
Graphics.\\nCOMPILACI\[CapitalOAcute]N:\\nEl archivo .tex generado debe \
compilarse con: pdflatex --shell-escape archivo.tex\\nLa animaci\[OAcute]n \
resultante funciona en Adobe Acrobat/Reader y navegadores web modernos.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"CreateTikZAnimation", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`plotFunc_", ",", 
                    "VilTeX`Private`paramSpecs_", ",", 
                    "VilTeX`Private`fileName_", ",", 
                    RowBox[{"VilTeX`Private`numFrames_", ":", "20"}], ",", 
                    RowBox[{"VilTeX`Private`frameRate_", ":", "5"}], ",", 
                    RowBox[{"VilTeX`Private`gridOption_", ":", "True"}], ",", 
                    
                    RowBox[{"VilTeX`Private`stylesOption_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`axesOption_", ":", "True"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xmin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`xmax_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymax_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`points_", ":", "False"}]}], "]"}],
                     ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`processedParams", ",", 
                    "VilTeX`Private`paramSequence", ",", 
                    "VilTeX`Private`tikzFrames", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`fileName", 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`fileName", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"IntegerQ", "[", "VilTeX`Private`numFrames", 
                    "]"}]}], "||", 
                    RowBox[{"VilTeX`Private`numFrames", "<", "2"}], "||", 
                    RowBox[{"VilTeX`Private`numFrames", ">", "200"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`frameRate", 
                    "]"}]}], "||", 
                    RowBox[{"VilTeX`Private`frameRate", "\[LessEqual]", "0"}],
                     "||", 
                    RowBox[{"VilTeX`Private`frameRate", ">", "60"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`paramSpecs", 
                    "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`paramSpecs", "]"}],
                     "\[Equal]", "0"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`processedParams", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`spec", "=", 
                    
                    RowBox[{"VilTeX`Private`paramSpecs", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`spec", ",", 
                    RowBox[{"{", 
                    RowBox[{"_Symbol", ",", 
                    RowBox[{"_", "?", "NumericQ"}], ",", 
                    RowBox[{"_", "?", "NumericQ"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`processedParams", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`spec", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`spec", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`spec", "\[LeftDoubleBracket]", 
                    "3", "\[RightDoubleBracket]"}], ",", "\"continuous\""}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`spec", ",", 
                    RowBox[{"{", 
                    RowBox[{"_Symbol", ",", "_List"}], "}"}]}], "]"}], ",", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`processedParams", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`spec", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`spec", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`spec", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", "\"discrete\""}], 
                    "}"}]}], "]"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`paramSpecs", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`processedParams", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`fileName", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`fileName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`paramSequence", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`param", ",", 
                    "VilTeX`Private`minVal", ",", "VilTeX`Private`maxVal", 
                    ",", "VilTeX`Private`paramType", ",", 
                    "VilTeX`Private`value"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`param", ",", 
                    "VilTeX`Private`minVal", ",", "VilTeX`Private`maxVal", 
                    ",", "VilTeX`Private`paramType"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`processedParams", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`value", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`paramType", "\[Equal]", 
                    "\"continuous\""}], ",", 
                    RowBox[{"N", "[", 
                    RowBox[{"VilTeX`Private`minVal", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`maxVal", "-", 
                    "VilTeX`Private`minVal"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    RowBox[{"VilTeX`Private`numFrames", "-", "1"}]]}], "]"}], 
                    ",", 
                    RowBox[{
                    "VilTeX`Private`paramType", "\[Equal]", "\"discrete\""}], 
                    ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`discreteValues", "=", 
                    "VilTeX`Private`minVal"}], ",", "VilTeX`Private`index"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`index", "=", 
                    RowBox[{"1", "+", 
                    RowBox[{"Floor", "[", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`discreteValues", 
                    "]"}], "-", "1"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    RowBox[{"VilTeX`Private`numFrames", "-", "1"}]], 
                    "]"}]}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`discreteValues", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`index", 
                    "\[RightDoubleBracket]"}]}]}], "]"}], ",", "True", ",", 
                    "0"}], "]"}]}], ";", "VilTeX`Private`value"}]}], "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`processedParams", 
                    "]"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numFrames"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzFrames", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlot", ",", 
                    "VilTeX`Private`paramValues"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`paramValues", "=", 
                    
                    RowBox[{"VilTeX`Private`paramSequence", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`frameNum", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPlot", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`plotFunc", "]"}], 
                    "===", "Function"}], ",", 
                    
                    RowBox[{"VilTeX`Private`plotFunc", "@@", 
                    "VilTeX`Private`paramValues"}], ",", 
                    
                    RowBox[{"VilTeX`Private`plotFunc", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"Thread", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`processedParams", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "\[Rule]", "VilTeX`Private`paramValues"}], "]"}]}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`currentPlot", ",", "_Graphics"}], 
                    "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`lineData", ",", 
                    "VilTeX`Private`pointData", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`formatNumber"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`result", ",", 
                    "VilTeX`Private`num"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`num", "=", 
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], "<", 
                    FractionBox["1", 
                    SuperscriptBox["10", "10"]]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    SuperscriptBox["10", "8"]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "1"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    "1000"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "0.01`"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", 
                    FractionBox["1", 
                    SuperscriptBox["10", "6"]]}], "]"}], ",", "InputForm"}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`result", "]"}], 
                    ",", "VilTeX`Private`result", ",", 
                    RowBox[{"ToString", "[", "VilTeX`Private`result", "]"}]}],
                     "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`lineData", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`currentPlot", ",", 
                    RowBox[{
                    RowBox[{"Line", "[", "VilTeX`Private`pts_", "]"}], 
                    "\[RuleDelayed]", "VilTeX`Private`pts"}], ",", 
                    "\[Infinity]"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`pointData", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`currentPlot", ",", 
                    RowBox[{
                    RowBox[{"Point", "[", "VilTeX`Private`pts_", "]"}], 
                    "\[RuleDelayed]", "VilTeX`Private`pts"}], ",", 
                    "\[Infinity]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`lineData", "]"}], 
                    "\[Equal]", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pointData", "]"}], 
                    "\[Equal]", "0"}]}], ",", 
                    RowBox[{"VilTeX`Private`lineData", "=", 
                    RowBox[{"{", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", 
                    RowBox[{"Sin", "[", "VilTeX`Private`x", "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`x", ",", "0", ",", "10", ",", 
                    "0.1`"}], "}"}]}], "]"}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xminFinal", ",", 
                    "VilTeX`Private`xmaxFinal", ",", 
                    "VilTeX`Private`yminFinal", ",", 
                    "VilTeX`Private`ymaxFinal", ",", 
                    "VilTeX`Private`allPoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allPoints", "=", 
                    RowBox[{"Join", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"VilTeX`Private`lineData", ",", "1"}], "]"}], ",", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"VilTeX`Private`pointData", ",", "1"}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "=!=", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`xmax", "=!=", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`ymin", "=!=", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`ymax", "=!=", "Automatic"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`allPoints", "]"}], 
                    ">", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Min", "[", 
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`xmin"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`xmax"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`ymin"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`ymax"}], "]"}]}], ";"}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    "0", ",", "VilTeX`Private`xmin"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"2", " ", "\[Pi]"}], ",", "VilTeX`Private`xmax"}],
                     "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"-", "1.5`"}], ",", "VilTeX`Private`ymin"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    "1.5`", ",", "VilTeX`Private`ymax"}], "]"}]}], ";"}]}], 
                    "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`allPoints", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xminFinal", "=", "0"}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"2", " ", "\[Pi]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"-", "1.5`"}]}], ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", "1.5`"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"\"% Frame \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`frameNum", "]"}],
                     "<>", "\"\\n\"", "<>", 
                    "\"\\\\begin{tikzpicture}\\n\\\\begin{axis}[\\n\"", "<>", 
                    "\"  xlabel={$x$},\\n\"", "<>", "\"  ylabel={$y$},\\n\"", 
                    "<>", "\"  xmin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xminFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  xmax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xmaxFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  ymin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yminFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  ymax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`ymaxFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  scaled ticks=false,\\n\"", "<>", 
                    "\"  tick label style={/pgf/number format/fixed},\\n\"", 
                    "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`gridOption", ",", 
                    "\"  grid=major,\\n\"", ",", "\"\""}], "]"}], "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`axesOption", ",", 
                    "\"  axis lines=center\\n\"", ",", 
                    "\"  axis lines=none\\n\""}], "]"}], "<>", "\"]\\n\"", 
                    "<>", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`color", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`color", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`stylesOption", 
                    "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\"red\"", ",", "\"blue\"", ",", "\"green\"", 
                    ",", "\"orange\"", ",", "\"purple\"", ",", "\"black\""}], 
                    "}"}], ",", "VilTeX`Private`stylesOption"}], "]"}]}], ",",
                     "VilTeX`Private`stylesOption", ",", "\"black\""}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`points", ",", 
                    RowBox[{
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pts", ",", 
                    "VilTeX`Private`validPts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`lineData", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`validPts", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[GreaterEqual]", 
                    "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "NumericQ"}], "]"}]}], "&"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`validPts", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{"\"\\\\addplot[\"", "<>", "VilTeX`Private`color", 
                    "<>", "\", only marks, mark=*, mark size=2pt] coordinates \
{\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`validPts"}], "}"}]}], "]"}], ",", 
                    "\"\\n\""}], "]"}], "<>", "\"\\n};\\n\""}], ",", 
                    "\"\""}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`lineData", "]"}]}],
                     "}"}]}], "]"}], "]"}], "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pts", ",", 
                    "VilTeX`Private`validPts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`validPts", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[GreaterEqual]", 
                    "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "NumericQ"}], "]"}]}], "&"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`validPts", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{"\"\\\\addplot[\"", "<>", "VilTeX`Private`color", 
                    "<>", "\", only marks, mark=*, mark size=2pt] coordinates \
{\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`validPts"}], "}"}]}], "]"}], ",", 
                    "\"\\n\""}], "]"}], "<>", "\"\\n};\\n\""}], ",", 
                    "\"\""}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`pointData", 
                    "]"}]}], "}"}]}], "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pts", ",", 
                    "VilTeX`Private`validPts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`lineData", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`validPts", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[GreaterEqual]", 
                    "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "NumericQ"}], "]"}]}], "&"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`validPts", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{"\"\\\\addplot[\"", "<>", "VilTeX`Private`color", 
                    "<>", "\", thick] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`validPts"}], "}"}]}], "]"}], ",", 
                    "\"\\n\""}], "]"}], "<>", "\"\\n};\\n\""}], ",", 
                    "\"\""}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`lineData", "]"}]}],
                     "}"}]}], "]"}], "]"}], "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pts", ",", 
                    "VilTeX`Private`validPts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`pointData", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`validPts", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[GreaterEqual]", 
                    "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "NumericQ"}], "]"}]}], "&"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`validPts", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{"\"\\\\addplot[\"", "<>", "VilTeX`Private`color", 
                    "<>", "\", only marks, mark=*, mark size=2pt] coordinates \
{\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`validPts"}], "}"}]}], "]"}], ",", 
                    "\"\\n\""}], "]"}], "<>", "\"\\n};\\n\""}], ",", 
                    "\"\""}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`pointData", 
                    "]"}]}], "}"}]}], "]"}], "]"}]}]}], "]"}]}]}], "]"}], 
                    "<>", "\"\\\\end{axis}\\n\\\\end{tikzpicture}\""}]}], ";",
                     "VilTeX`Private`tikzCode"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"\"% Error en frame \"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`frameNum", 
                    "]"}]}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`frameNum", ",", 
                    "VilTeX`Private`numFrames"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage{pgfplots}\\n\"", "<>", 
                    "\"\\\\usepackage{animate}\\n\"", "<>", 
                    "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usepackage{amssymb}\\n\"", "<>", 
                    "\"\\\\pgfplotsset{compat=1.18}\\n\\n\"", "<>", 
                    "\"\\\\begin{document}\\n\"", "<>", 
                    "\"\\\\begin{animateinline}[controls,loop]{\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`frameRate", 
                    "]"}], "<>", "\"}\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    
                    RowBox[{"VilTeX`Private`tikzFrames", ",", 
                    "\"\\n\\\\newframe\\n\""}], "]"}], "<>", 
                    "\"\\n\\\\end{animateinline}\\n\"", "<>", 
                    "\"\\\\end{document}\""}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`CreateTikZAnimation\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"CreateTikZAnimation[plotFunc, paramSpecs, fileName] \
crea una animaci\[OAcute]n LaTeX usando el paquete 'animate' a partir de una \
funci\[OAcute]n pura de Mathematica que genera gr\[AAcute]ficos.\\n\\nPAR\
\[CapitalAAcute]METROS:\\nplotFunc: Function pura que genera objetos \
Graphics. Debe usar la sintaxis Function[{var1, var2, ...}, \
expresi\[OAcute]n] o expresi\[OAcute]n & para un \
par\[AAcute]metro.\\nparamSpecs: Lista de especificaciones de \
par\[AAcute]metros en formato {{var, min, max}, ...} para par\[AAcute]metros \
continuos o {{var, {val1, val2, ...}}, ...} para par\[AAcute]metros \
discretos.\\nfileName: String con el nombre del archivo .tex de salida (debe \
incluir extensi\[OAcute]n .tex).\\nOPCIONES:\\nnumFrames: Entero entre 2 y \
200 que especifica el n\[UAcute]mero de frames de la animaci\[OAcute]n \
(default: 20).\\nframeRate: N\[UAcute]mero entre 0 y 60 que especifica los \
frames por segundo (default: 5).\\ngridOption: True/False para \
mostrar/ocultar la cuadr\[IAcute]cula en el gr\[AAcute]fico (default: \
True).\\nstylesOption: String con el color de las l\[IAcute]neas. Valores v\
\[AAcute]lidos: \\\"red\\\", \\\"blue\\\", \\\"green\\\", \\\"orange\\\", \
\\\"purple\\\", \\\"black\\\" (default: \\\"black\\\").\\naxesOption: \
True/False para mostrar/ocultar los ejes del gr\[AAcute]fico (default: True).\
\\nxmin: N\[UAcute]mero que especifica el valor m\[IAcute]nimo del eje X \
(default: Automatic - se calcula autom\[AAcute]ticamente).\\nxmax: \
N\[UAcute]mero que especifica el valor m\[AAcute]ximo del eje X (default: \
Automatic - se calcula autom\[AAcute]ticamente).\\nymin: N\[UAcute]mero que \
especifica el valor m\[IAcute]nimo del eje Y (default: Automatic - se calcula \
autom\[AAcute]ticamente).\\nymax: N\[UAcute]mero que especifica el valor m\
\[AAcute]ximo del eje Y (default: Automatic - se calcula \
autom\[AAcute]ticamente).\\npoints: True/False para mostrar puntos discretos \
en lugar de l\[IAcute]neas continuas. Cuando es True, las l\[IAcute]neas se \
muestran como puntos circulares rellenos (default: False).\\nVALOR DE \
RETORNO:\\nString con la ruta completa del archivo .tex generado, o \
\\\\$Failed si hay errores.\\nEJEMPLOS:\\nCreateTikZAnimation[Function[{a}, \
Plot[Sin[a*x], {x, 0, 2\[Pi]}]], {{a, 1, 5}}, \
\\\"seno.tex\\\"]\\nCreateTikZAnimation[Plot[Sin[#*x], {x, 0, 2\[Pi]}] &, \
{{a, 1, 5}}, \\\"seno.tex\\\", 30, 8, True, \\\"blue\\\", True, 0, 2\[Pi], \
-1.5, 1.5]\\nCreateTikZAnimation[Function[{a, b}, Plot[a*Sin[b*x], {x, 0, 2\
\[Pi]}]], {{a, 0.5, 2}, {b, 1, 4}}, \
\\\"complejo.tex\\\"]\\nCreateTikZAnimation[Function[{amp}, \
ListPlot[Table[{x, amp*Sin[x]}, {x, 0, 6, 0.2}], Joined -> True]], {{amp, \
0.5, 2}}, \\\"puntos.tex\\\", points -> True]\\nCOMPATIBILIDAD:\\nFunciona \
con Plot, ParametricPlot, PolarPlot, ListLinePlot, ListPlot, LogPlot y \
cualquier funci\[OAcute]n que genere primitivas Line dentro de objetos \
Graphics.\\nCOMPILACI\[CapitalOAcute]N:\\nEl archivo .tex generado debe \
compilarse con: pdflatex --shell-escape archivo.tex\\nLa animaci\[OAcute]n \
resultante funciona en Adobe Acrobat/Reader y navegadores web modernos.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "CreateTikZAnimation[plotFunc, paramSpecs, fileName] crea una animaci\
\[OAcute]n LaTeX usando el paquete 'animate' a partir de una funci\[OAcute]n \
pura de Mathematica que genera gr\[AAcute]ficos.\n\n\
PAR\[CapitalAAcute]METROS:\nplotFunc: Function pura que genera objetos \
Graphics. Debe usar la sintaxis Function[{var1, var2, ...}, \
expresi\[OAcute]n] o expresi\[OAcute]n & para un par\[AAcute]metro.\n\
paramSpecs: Lista de especificaciones de par\[AAcute]metros en formato {{var, \
min, max}, ...} para par\[AAcute]metros continuos o {{var, {val1, val2, \
...}}, ...} para par\[AAcute]metros discretos.\nfileName: String con el \
nombre del archivo .tex de salida (debe incluir extensi\[OAcute]n .tex).\n\
OPCIONES:\nnumFrames: Entero entre 2 y 200 que especifica el n\[UAcute]mero \
de frames de la animaci\[OAcute]n (default: 20).\nframeRate: N\[UAcute]mero \
entre 0 y 60 que especifica los frames por segundo (default: 5).\ngridOption: \
True/False para mostrar/ocultar la cuadr\[IAcute]cula en el gr\[AAcute]fico \
(default: True).\nstylesOption: String con el color de las l\[IAcute]neas. \
Valores v\[AAcute]lidos: \"red\", \"blue\", \"green\", \"orange\", \
\"purple\", \"black\" (default: \"black\").\naxesOption: True/False para \
mostrar/ocultar los ejes del gr\[AAcute]fico (default: True).\nxmin: N\
\[UAcute]mero que especifica el valor m\[IAcute]nimo del eje X (default: \
Automatic - se calcula autom\[AAcute]ticamente).\nxmax: N\[UAcute]mero que \
especifica el valor m\[AAcute]ximo del eje X (default: Automatic - se calcula \
autom\[AAcute]ticamente).\nymin: N\[UAcute]mero que especifica el valor m\
\[IAcute]nimo del eje Y (default: Automatic - se calcula \
autom\[AAcute]ticamente).\nymax: N\[UAcute]mero que especifica el valor m\
\[AAcute]ximo del eje Y (default: Automatic - se calcula \
autom\[AAcute]ticamente).\npoints: True/False para mostrar puntos discretos \
en lugar de l\[IAcute]neas continuas. Cuando es True, las l\[IAcute]neas se \
muestran como puntos circulares rellenos (default: False).\nVALOR DE RETORNO:\
\nString con la ruta completa del archivo .tex generado, o \\$Failed si hay \
errores.\nEJEMPLOS:\nCreateTikZAnimation[Function[{a}, Plot[Sin[a*x], {x, 0, \
2\[Pi]}]], {{a, 1, 5}}, \"seno.tex\"]\nCreateTikZAnimation[Plot[Sin[#*x], {x, \
0, 2\[Pi]}] &, {{a, 1, 5}}, \"seno.tex\", 30, 8, True, \"blue\", True, 0, 2\
\[Pi], -1.5, 1.5]\nCreateTikZAnimation[Function[{a, b}, Plot[a*Sin[b*x], {x, \
0, 2\[Pi]}]], {{a, 0.5, 2}, {b, 1, 4}}, \"complejo.tex\"]\n\
CreateTikZAnimation[Function[{amp}, ListPlot[Table[{x, amp*Sin[x]}, {x, 0, 6, \
0.2}], Joined -> True]], {{amp, 0.5, 2}}, \"puntos.tex\", points -> True]\n\
COMPATIBILIDAD:\nFunciona con Plot, ParametricPlot, PolarPlot, ListLinePlot, \
ListPlot, LogPlot y cualquier funci\[OAcute]n que genere primitivas Line \
dentro de objetos Graphics.\nCOMPILACI\[CapitalOAcute]N:\nEl archivo .tex \
generado debe compilarse con: pdflatex --shell-escape archivo.tex\nLa animaci\
\[OAcute]n resultante funciona en Adobe Acrobat/Reader y navegadores web \
modernos.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`CreateTikZAnimation, {VilTeX`CreateTikZAnimation[
         Pattern[VilTeX`Private`plotFunc, 
          Blank[]], 
         Pattern[VilTeX`Private`paramSpecs, 
          Blank[]], 
         Pattern[VilTeX`Private`fileName, 
          Blank[]], 
         Optional[
          Pattern[VilTeX`Private`numFrames, 
           Blank[]], 20], 
         Optional[
          Pattern[VilTeX`Private`frameRate, 
           Blank[]], 5], 
         Optional[
          Pattern[VilTeX`Private`gridOption, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`stylesOption, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`axesOption, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`xmin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`xmax, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymax, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`points, 
           Blank[]], False]] :> 
       Module[{VilTeX`Private`processedParams, VilTeX`Private`paramSequence, 
          VilTeX`Private`tikzFrames, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderName, 
          VilTeX`Private`folderPath}, If[
           Not[
            StringQ[VilTeX`Private`fileName]], 
           Return[$Failed]]; If[
           Not[
            StringEndsQ[VilTeX`Private`fileName, ".tex"]], 
           Return[$Failed]]; If[
           Or[
            Not[
             IntegerQ[VilTeX`Private`numFrames]], VilTeX`Private`numFrames < 
            2, VilTeX`Private`numFrames > 200], 
           Return[$Failed]]; If[
           Or[
            Not[
             NumericQ[VilTeX`Private`frameRate]], VilTeX`Private`frameRate <= 
            0, VilTeX`Private`frameRate > 60], 
           Return[$Failed]]; If[
           Or[
            Not[
             ListQ[VilTeX`Private`paramSpecs]], 
            Length[VilTeX`Private`paramSpecs] == 0], 
           Return[$Failed]]; VilTeX`Private`processedParams = {}; Do[
           
           Module[{VilTeX`Private`spec = 
             Part[VilTeX`Private`paramSpecs, VilTeX`Private`i]}, 
            Which[
             MatchQ[VilTeX`Private`spec, {
               Blank[Symbol], 
               PatternTest[
                Blank[], NumericQ], 
               PatternTest[
                Blank[], NumericQ]}], 
             AppendTo[VilTeX`Private`processedParams, {
               Part[VilTeX`Private`spec, 1], 
               Part[VilTeX`Private`spec, 2], 
               Part[VilTeX`Private`spec, 3], "continuous"}], 
             MatchQ[VilTeX`Private`spec, {
               Blank[Symbol], 
               Blank[List]}], 
             AppendTo[VilTeX`Private`processedParams, {
               Part[VilTeX`Private`spec, 1], 
               Part[VilTeX`Private`spec, 2], 
               Part[VilTeX`Private`spec, 2], "discrete"}]]], {
           VilTeX`Private`i, 
            Length[VilTeX`Private`paramSpecs]}]; 
         If[Length[VilTeX`Private`processedParams] == 0, 
           Return[$Failed]]; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`fileName]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`fileName}]; 
         VilTeX`Private`paramSequence = Table[
            Table[
             
             Module[{VilTeX`Private`param, VilTeX`Private`minVal, 
               VilTeX`Private`maxVal, VilTeX`Private`paramType, 
               VilTeX`Private`value}, {
                VilTeX`Private`param, VilTeX`Private`minVal, 
                 VilTeX`Private`maxVal, VilTeX`Private`paramType} = 
               Part[VilTeX`Private`processedParams, VilTeX`Private`j]; 
              VilTeX`Private`value = 
               Which[VilTeX`Private`paramType == "continuous", 
                 N[
                 VilTeX`Private`minVal + (VilTeX`Private`maxVal - 
                    VilTeX`Private`minVal) ((VilTeX`Private`i - 1)/(
                    VilTeX`Private`numFrames - 1))], VilTeX`Private`paramType == 
                 "discrete", 
                 
                 Module[{
                  VilTeX`Private`discreteValues = VilTeX`Private`minVal, 
                   VilTeX`Private`index}, 
                  VilTeX`Private`index = 
                   1 + Floor[(Length[VilTeX`Private`discreteValues] - 
                    1) ((VilTeX`Private`i - 1)/(VilTeX`Private`numFrames - 
                    1))]; Part[
                   VilTeX`Private`discreteValues, VilTeX`Private`index]], 
                 True, 0]; VilTeX`Private`value], {VilTeX`Private`j, 
              Length[VilTeX`Private`processedParams]}], {
            VilTeX`Private`i, VilTeX`Private`numFrames}]; 
         VilTeX`Private`tikzFrames = Table[
            
            Module[{VilTeX`Private`currentPlot, VilTeX`Private`paramValues}, 
             VilTeX`Private`paramValues = 
              Part[VilTeX`Private`paramSequence, VilTeX`Private`frameNum]; 
             VilTeX`Private`currentPlot = 
              If[Head[VilTeX`Private`plotFunc] === Function, 
                Apply[VilTeX`Private`plotFunc, VilTeX`Private`paramValues], 
                ReplaceAll[VilTeX`Private`plotFunc, 
                 Thread[
                 Part[VilTeX`Private`processedParams, All, 1] -> 
                  VilTeX`Private`paramValues]]]; If[
               MatchQ[VilTeX`Private`currentPlot, 
                Blank[Graphics]], 
               
               Module[{
                VilTeX`Private`lineData, VilTeX`Private`pointData, 
                 VilTeX`Private`tikzCode, VilTeX`Private`formatNumber}, 
                VilTeX`Private`formatNumber[
                   Pattern[VilTeX`Private`x, 
                    Blank[]]] := 
                 Module[{VilTeX`Private`result, VilTeX`Private`num}, If[
                    NumericQ[VilTeX`Private`x], 
                    VilTeX`Private`num = N[VilTeX`Private`x]; 
                    If[Abs[VilTeX`Private`num] < 10^(-10), 
                    VilTeX`Private`result = "0", 
                    If[
                    Abs[VilTeX`Private`num] > 10^8, VilTeX`Private`result = 
                    ToString[
                    Round[VilTeX`Private`num, 1], InputForm], 
                    If[
                    Abs[VilTeX`Private`num] > 1000, VilTeX`Private`result = 
                    ToString[
                    Round[VilTeX`Private`num, 0.01], InputForm], 
                    VilTeX`Private`result = ToString[
                    Round[VilTeX`Private`num, 10^(-6)], InputForm]]]]; Null, 
                    VilTeX`Private`result = "0"]; If[
                    StringQ[VilTeX`Private`result], VilTeX`Private`result, 
                    ToString[VilTeX`Private`result]]]; 
                VilTeX`Private`lineData = 
                 Cases[VilTeX`Private`currentPlot, Line[
                    Pattern[VilTeX`Private`pts, 
                    Blank[]]] :> VilTeX`Private`pts, Infinity]; 
                VilTeX`Private`pointData = 
                 Cases[VilTeX`Private`currentPlot, Point[
                    Pattern[VilTeX`Private`pts, 
                    Blank[]]] :> VilTeX`Private`pts, Infinity]; If[
                  And[
                  Length[VilTeX`Private`lineData] == 0, 
                   Length[VilTeX`Private`pointData] == 0], 
                  VilTeX`Private`lineData = {
                    Table[{VilTeX`Private`x, 
                    Sin[VilTeX`Private`x]}, {VilTeX`Private`x, 0, 10, 0.1}]}]; 
                Module[{
                  VilTeX`Private`xminFinal, VilTeX`Private`xmaxFinal, 
                   VilTeX`Private`yminFinal, VilTeX`Private`ymaxFinal, 
                   VilTeX`Private`allPoints}, 
                  VilTeX`Private`allPoints = Join[
                    Flatten[VilTeX`Private`lineData, 1], 
                    Flatten[VilTeX`Private`pointData, 1]]; If[
                    Or[
                    VilTeX`Private`xmin =!= Automatic, VilTeX`Private`xmax =!= 
                    Automatic, VilTeX`Private`ymin =!= Automatic, 
                    VilTeX`Private`ymax =!= Automatic], If[
                    And[Length[VilTeX`Private`allPoints] > 0, Length[
                    Part[VilTeX`Private`allPoints, 1]] >= 2], 
                    VilTeX`Private`xminFinal = 
                    If[VilTeX`Private`xmin === Automatic, 
                    Min[
                    Part[VilTeX`Private`allPoints, All, 1]], 
                    VilTeX`Private`xmin]; 
                    VilTeX`Private`xmaxFinal = 
                    If[VilTeX`Private`xmax === Automatic, 
                    Max[
                    Part[VilTeX`Private`allPoints, All, 1]], 
                    VilTeX`Private`xmax]; 
                    VilTeX`Private`yminFinal = 
                    If[VilTeX`Private`ymin === Automatic, 
                    Min[
                    Part[VilTeX`Private`allPoints, All, 2]], 
                    VilTeX`Private`ymin]; 
                    VilTeX`Private`ymaxFinal = 
                    If[VilTeX`Private`ymax === Automatic, 
                    Max[
                    Part[VilTeX`Private`allPoints, All, 2]], 
                    VilTeX`Private`ymax]; Null, 
                    VilTeX`Private`xminFinal = 
                    If[VilTeX`Private`xmin === Automatic, 0, 
                    VilTeX`Private`xmin]; 
                    VilTeX`Private`xmaxFinal = 
                    If[VilTeX`Private`xmax === Automatic, 2 Pi, 
                    VilTeX`Private`xmax]; 
                    VilTeX`Private`yminFinal = 
                    If[VilTeX`Private`ymin === Automatic, -1.5, 
                    VilTeX`Private`ymin]; 
                    VilTeX`Private`ymaxFinal = 
                    If[VilTeX`Private`ymax === Automatic, 1.5, 
                    VilTeX`Private`ymax]; Null]; Null, 
                    If[Length[VilTeX`Private`allPoints] > 0, 
                    VilTeX`Private`xminFinal = Min[
                    Part[VilTeX`Private`allPoints, All, 1]]; 
                    VilTeX`Private`xmaxFinal = Max[
                    Part[VilTeX`Private`allPoints, All, 1]]; 
                    VilTeX`Private`yminFinal = Min[
                    Part[VilTeX`Private`allPoints, All, 2]]; 
                    VilTeX`Private`ymaxFinal = Max[
                    Part[VilTeX`Private`allPoints, All, 2]]; Null, 
                    VilTeX`Private`xminFinal = 0; 
                    VilTeX`Private`xmaxFinal = 2 Pi; 
                    VilTeX`Private`yminFinal = -1.5; 
                    VilTeX`Private`ymaxFinal = 1.5; Null]; Null]; 
                  VilTeX`Private`tikzCode = 
                   "% Frame " <> ToString[VilTeX`Private`frameNum] <> "\n" <> 
                    "\\begin{tikzpicture}\n\\begin{axis}[\n" <> 
                    "  xlabel={$x$},\n" <> "  ylabel={$y$},\n" <> "  xmin=" <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`xminFinal] <> 
                    ",\n" <> "  xmax=" <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`xmaxFinal] <> 
                    ",\n" <> "  ymin=" <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`yminFinal] <> 
                    ",\n" <> "  ymax=" <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`ymaxFinal] <> 
                    ",\n" <> "  scaled ticks=false,\n" <> 
                    "  tick label style={/pgf/number format/fixed},\n" <> 
                    If[VilTeX`Private`gridOption, "  grid=major,\n", ""] <> 
                    If[VilTeX`Private`axesOption, "  axis lines=center\n", 
                    "  axis lines=none\n"] <> "]\n" <> 
                    Module[{VilTeX`Private`color}, VilTeX`Private`color = If[
                    And[
                    StringQ[VilTeX`Private`stylesOption], 
                    
                    MemberQ[{
                    "red", "blue", "green", "orange", "purple", "black"}, 
                    VilTeX`Private`stylesOption]], 
                    VilTeX`Private`stylesOption, "black"]; 
                    If[VilTeX`Private`points, StringJoin[
                    Table[
                    
                    Module[{VilTeX`Private`pts, VilTeX`Private`validPts}, 
                    VilTeX`Private`pts = 
                    Part[VilTeX`Private`lineData, VilTeX`Private`i]; 
                    VilTeX`Private`validPts = 
                    Select[VilTeX`Private`pts, And[Length[#] >= 2, 
                    AllTrue[#, NumericQ]]& ]; 
                    If[Length[VilTeX`Private`validPts] > 0, "\\addplot[" <> 
                    VilTeX`Private`color <> 
                    ", only marks, mark=*, mark size=2pt] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 1]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 2]] <> ")", {
                    VilTeX`Private`pt, VilTeX`Private`validPts}], "\n"] <> 
                    "\n};\n", ""]], {VilTeX`Private`i, 
                    Length[VilTeX`Private`lineData]}]] <> StringJoin[
                    Table[
                    
                    Module[{VilTeX`Private`pts, VilTeX`Private`validPts}, 
                    VilTeX`Private`pts = 
                    Part[VilTeX`Private`pointData, VilTeX`Private`i]; 
                    VilTeX`Private`validPts = 
                    Select[VilTeX`Private`pts, And[Length[#] >= 2, 
                    AllTrue[#, NumericQ]]& ]; 
                    If[Length[VilTeX`Private`validPts] > 0, "\\addplot[" <> 
                    VilTeX`Private`color <> 
                    ", only marks, mark=*, mark size=2pt] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 1]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 2]] <> ")", {
                    VilTeX`Private`pt, VilTeX`Private`validPts}], "\n"] <> 
                    "\n};\n", ""]], {VilTeX`Private`i, 
                    Length[VilTeX`Private`pointData]}]], StringJoin[
                    Table[
                    
                    Module[{VilTeX`Private`pts, VilTeX`Private`validPts}, 
                    VilTeX`Private`pts = 
                    Part[VilTeX`Private`lineData, VilTeX`Private`i]; 
                    VilTeX`Private`validPts = 
                    Select[VilTeX`Private`pts, And[Length[#] >= 2, 
                    AllTrue[#, NumericQ]]& ]; 
                    If[Length[VilTeX`Private`validPts] > 0, "\\addplot[" <> 
                    VilTeX`Private`color <> ", thick] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 1]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 2]] <> ")", {
                    VilTeX`Private`pt, VilTeX`Private`validPts}], "\n"] <> 
                    "\n};\n", ""]], {VilTeX`Private`i, 
                    Length[VilTeX`Private`lineData]}]] <> StringJoin[
                    Table[
                    
                    Module[{VilTeX`Private`pts, VilTeX`Private`validPts}, 
                    VilTeX`Private`pts = 
                    Part[VilTeX`Private`pointData, VilTeX`Private`i]; 
                    VilTeX`Private`validPts = 
                    Select[VilTeX`Private`pts, And[Length[#] >= 2, 
                    AllTrue[#, NumericQ]]& ]; 
                    If[Length[VilTeX`Private`validPts] > 0, "\\addplot[" <> 
                    VilTeX`Private`color <> 
                    ", only marks, mark=*, mark size=2pt] coordinates {\n" <> 
                    StringRiffle[
                    Table["  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 1]] <> "," <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 2]] <> ")", {
                    VilTeX`Private`pt, VilTeX`Private`validPts}], "\n"] <> 
                    "\n};\n", ""]], {VilTeX`Private`i, 
                    Length[VilTeX`Private`pointData]}]]]] <> 
                    "\\end{axis}\n\\end{tikzpicture}"; 
                  VilTeX`Private`tikzCode]], "% Error en frame " <> 
               ToString[VilTeX`Private`frameNum]]], {
            VilTeX`Private`frameNum, VilTeX`Private`numFrames}]; 
         VilTeX`Private`fullDocument = 
          "\\documentclass[border=5mm]{standalone}\n" <> 
           "\\usepackage{tikz}\n" <> "\\usepackage{pgfplots}\n" <> 
           "\\usepackage{animate}\n" <> "\\usepackage{amsmath}\n" <> 
           "\\usepackage{amssymb}\n" <> "\\pgfplotsset{compat=1.18}\n\n" <> 
           "\\begin{document}\n" <> "\\begin{animateinline}[controls,loop]{" <> 
           ToString[VilTeX`Private`frameRate] <> "}\n" <> 
           StringRiffle[VilTeX`Private`tikzFrames, "\n\\newframe\n"] <> 
           "\n\\end{animateinline}\n" <> "\\end{document}"; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`CreateTikZAnimation"|>, False]]], "Output",
 CellChangeTimes->{3.9675540090228214`*^9, 3.96755435941131*^9, 
  3.967829596292116*^9, 3.9679193141910553`*^9, 3.9679794994375477`*^9, 
  3.96797965118611*^9, 3.96798200197184*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"8c917844-1ce4-4a7d-a8b8-172a67955eb6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: frecuencia de una onda", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 
  3.96781287770467*^9}},ExpressionUUID->"e23d2182-e714-5f48-ab0a-\
f012380117ba"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Pi]", "*", "n", "*", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0.5", ",", "5"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "30"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", "0"}], ",", 
   RowBox[{"xmax", "=", "3"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.5"}]}], ",", 
   RowBox[{"ymax", "=", "1.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"2", "\[Pi]", "*", "n", "*", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0.5", ",", "5"}], "}"}], "}"}], 
    ",", "\"\<animation1.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.967979662777676*^9, 3.967979697357318*^9}, 
   3.967980345822275*^9, {3.967980906544488*^9, 3.9679809074120283`*^9}, 
   3.970746080627029*^9},ExpressionUUID->"236b5b4a-930a-6d44-b4c0-\
0a6228af7ad0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 0.5, 5, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {207.53678638396673`, 219.00065357146673`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 0.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Plot[
        Sin[2 Pi $CellContext`n$$ $CellContext`x], {$CellContext`x, 0, 2}], 
      "Specifications" :> {{$CellContext`n$$, 0.5, 5}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {298.87763721404485`, 310.34150440154485`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.967813003196232*^9, 3.9678130320793095`*^9}, 
   3.967813063297964*^9, 3.967813161631851*^9, 3.967813198055708*^9, 
   3.9678133778392696`*^9, 3.9678135206045876`*^9, 3.967813861134863*^9, 
   3.96782969971539*^9, 3.967980045156728*^9, 3.9679804529701977`*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"213024be-a7a7-4b31-aafa-e40934ab248e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "30", ",", "8", ",", "True", ",", "\<\"green\"\>", ",", "True", ",", "0", ",",
    "3", ",", 
   RowBox[{"-", "1.5`"}], ",", "1.5`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.967813003196232*^9, 3.9678130320793095`*^9}, 
   3.967813063297964*^9, 3.967813161631851*^9, 3.967813198055708*^9, 
   3.9678133778392696`*^9, 3.9678135206045876`*^9, 3.967813861134863*^9, 
   3.96782969971539*^9, 3.967980045156728*^9, 3.967980453000576*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"a0fd58a2-28fc-40af-b419-72ad52371269"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980454043665*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"ee6cf728-11d5-42e7-8e59-4257deae8800"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980454044115*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"81e0a02f-7cca-409f-ba4f-0487c837c808"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980454044814*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"a3a28c9e-8786-48cd-b11a-5aaf2922aa13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980454045216*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"c11d7457-bcfa-43e2-aede-b27e300e78c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.9679804540456133`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"3fe9d1a5-7e2a-449b-834d-f5e89a77bd03"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980454105612*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"8bd6428e-b043-4718-9a19-087f52a36df9"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.9679804551111603`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"6eb73eed-fe04-4a72-b5e0-737d4768b5f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation1/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.9679804551138153`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"bfa0ecc6-8487-4314-87f5-a254be987555"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation1\"\>"}],
  SequenceForm["Archivo: ", "animation1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980455115988*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"9872c47e-62f6-4bba-aef1-94244c717253"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980482417818*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"7446248a-07d1-4cb4-812d-d7494c0e63b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation1/animation1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation1/animation1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96781306467614*^9, 3.967813163691433*^9, 
  3.9678131999768696`*^9, 3.9678133799564495`*^9, 3.9678135226922817`*^9, 
  3.9678138630394516`*^9, 3.967829700796226*^9, 3.967980046227467*^9, 
  3.967980482418548*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[35]:=",ExpressionUUID->"7de2c57a-c744-4acb-8aa4-0ba210a2bf52"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation1/\
animation1.pdf\"\>"], "Output",
 CellChangeTimes->{{3.967813003196232*^9, 3.9678130320793095`*^9}, 
   3.967813063297964*^9, 3.967813161631851*^9, 3.967813198055708*^9, 
   3.9678133778392696`*^9, 3.9678135206045876`*^9, 3.967813861134863*^9, 
   3.96782969971539*^9, 3.967980045156728*^9, 3.967980482432105*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"0c3a8394-36e9-4d9b-8429-321e2af52e54"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: batimiento de ondas (interferencia)", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
  3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
  3.967814002142147*^9}},ExpressionUUID->"a30762b1-6539-5143-a0b1-\
040519a02298"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", "\[Pi]", "*", "5", "*", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "\[Pi]", "*", "n", "*", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4.5", ",", "5.5"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "40"}], ",", 
   RowBox[{"framesxSeg", "=", "6"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", "0"}], ",", 
   RowBox[{"xmax", "=", "3"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.5"}]}], ",", 
   RowBox[{"ymax", "=", "1.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", "*", "5", "*", "x"}], "]"}], "+", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", "*", "n", "*", "x"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"n", ",", "4.5", ",", "5.5"}], "}"}], "}"}], 
    ",", "\"\<animation2.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, {3.96797970475154*^9, 3.967979711653143*^9}, 
   3.9679803425072927`*^9, 3.967980917177018*^9, 
   3.9707460878084373`*^9},ExpressionUUID->"c56723d5-b545-b44a-b534-\
92cd0b6399d2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 4.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 4.5, 5.5, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {212.7962832190314, 224.2601504065314}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 4.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      Plot[Sin[2 Pi 5 $CellContext`x] + 
        Sin[2 Pi $CellContext`n$$ $CellContext`x], {$CellContext`x, 0, 2}], 
      "Specifications" :> {{$CellContext`n$$, 4.5, 5.5}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {304.13713404910953`, 315.60100123660953`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.9678141180849667`*^9, 3.9678142484923897`*^9, 
  3.967830325573786*^9, 3.96798010463232*^9, 3.967980515756729*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"4465c8da-1a81-4500-b91c-7414e54bd0b5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "40", ",", "6", ",", "True", ",", "\<\"purple\"\>", ",", "True", ",", "0", ",",
    "3", ",", 
   RowBox[{"-", "1.5`"}], ",", "1.5`", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.9678141180849667`*^9, 3.9678142484923897`*^9, 
  3.967830325573786*^9, 3.96798010463232*^9, 3.967980515784855*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"213837bd-ae9a-444b-b4e5-915fb40f2466"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980517294626*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"2b2e393a-46ea-469c-91b0-ac05d14dcea1"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980517295164*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"ff79b2cb-d3c6-45b7-b5bc-6f6547a97eac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980517295879*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"0504124b-7395-4959-9cf1-02e31fbded93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980517296283*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"67db3bcc-3724-4055-8cb4-b0bf3a4e7a17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980517296691*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"6f3af497-6819-485f-b458-c4a40dad4315"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980517362315*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"6bee39cd-d82a-4a38-b7b9-5bb88560122d"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980518367838*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"24816fec-b033-4239-9bbe-fa81739f87ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation2/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980518369755*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"42095ebe-4a9f-4b26-a865-9806444cf83e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation2\"\>"}],
  SequenceForm["Archivo: ", "animation2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980518371058*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"3fc0b8b8-4150-44a7-9c43-e74adbc7522e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.9679805523466663`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"f8b27419-4a78-4583-b183-2ab7a6a84a7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation2/animation2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation2/animation2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678141205822754`*^9, 3.9678142514547863`*^9, 
  3.96783032707205*^9, 3.96798010620049*^9, 3.967980552350752*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[39]:=",ExpressionUUID->"f2dfc0fb-8908-4ea9-b42e-abedc68dad87"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation2/\
animation2.pdf\"\>"], "Output",
 CellChangeTimes->{3.9678141180849667`*^9, 3.9678142484923897`*^9, 
  3.967830325573786*^9, 3.96798010463232*^9, 3.9679805523841867`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"8e28cae4-f847-4628-9a26-cbe647009d5e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: par\[AAcute]bola con v\[EAcute]rtice m\[OAcute]vil", \
"Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, 3.96781428242696*^9, {3.9678144223224792`*^9, 
   3.967814429960966*^9}},ExpressionUUID->"7356247a-cfc8-ec4d-b06c-\
664651297cc5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "h"}], ")"}], "^", "2"}], "-", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "25"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{"xmax", "=", "3"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.5"}]}], ",", 
   RowBox[{"ymax", "=", "1.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "h", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "h"}], ")"}], "^", "2"}], "-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"h", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], "}"}], 
    ",", "\"\<animation3.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, {3.9678143572324295`*^9, 3.967814357873495*^9}, {
   3.967814447294073*^9, 3.967814512745247*^9}, {3.9678145718758335`*^9, 
   3.9678146023019295`*^9}, {3.967833209709738*^9, 3.967833210526771*^9}, {
   3.967979718082766*^9, 3.96797972504972*^9}, 3.967980338638812*^9, 
   3.967980923478119*^9, 
   3.970746095171562*^9},ExpressionUUID->"83d32608-ba28-fd4a-8a53-\
1d9a3168048a"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`h$$ = -2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`h$$], -2, 2, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {227.5051263730873, 238.9689935605873}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`h$$ = -2}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      Plot[($CellContext`x - $CellContext`h$$)^2 - 1, {$CellContext`x, -3, 3},
         PlotRange -> {-1.5, 1.5}], 
      "Specifications" :> {{$CellContext`h$$, -2, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {318.84597720316543`, 330.30984439066543`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.96781452866815*^9, {3.967814577855652*^9, 3.9678146040322037`*^9}, 
   3.967830447712392*^9, 3.967980169997758*^9, 3.967980571608123*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"385cbc9e-a2c3-4b02-941d-a5f8d7a73f0f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "8", ",", "False", ",", "\<\"blue\"\>", ",", "True", ",", 
   RowBox[{"-", "3"}], ",", "3", ",", 
   RowBox[{"-", "1.5`"}], ",", "1.5`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.96781452866815*^9, {3.967814577855652*^9, 3.9678146040322037`*^9}, 
   3.967830447712392*^9, 3.967980169997758*^9, 3.967980571636959*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"9eb23df2-d2fc-4962-b18f-fd3a1b79ed7c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980571866894*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"5eba342a-01e9-4c5f-98d5-6dee5ed4c4a5"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980571867412*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"1eec280f-fb6e-4f50-ae61-be65c1b717b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980571868108*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"c05f6260-9d42-4510-b139-5fb70e740b4e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.9679805718685017`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"2076e2fe-ac07-47a4-926c-6e5e3e5adeba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.9679805718689013`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"5f884a56-de3f-434c-9636-6f2f556c2c36"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.9679805719275827`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"5f6f15f1-043a-4ef0-bcf1-21d1ac82148b"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980572932747*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"22ef540f-d1a3-4431-8fd2-bb6c90082edf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation3/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980572935279*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"35546ba6-29bb-4233-8b9c-66989dbfa292"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation3\"\>"}],
  SequenceForm["Archivo: ", "animation3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980572937303*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"a01844d3-070a-4566-bb0c-6ff792378e0c"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980577630229*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"c5682f00-d76d-4a3d-a196-40400ecd0d17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation3/animation3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation3/animation3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814529186348*^9, {3.9678145783488045`*^9, 3.9678146045790997`*^9}, 
   3.9678304479613447`*^9, 3.967980170249488*^9, 3.967980577630967*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[43]:=",ExpressionUUID->"42c8bb4c-eaf1-4372-b4ab-16566fcb4b90"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation3/\
animation3.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.96781452866815*^9, {3.967814577855652*^9, 3.9678146040322037`*^9}, 
   3.967830447712392*^9, 3.967980169997758*^9, 3.967980577644833*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"51cc3dde-2deb-4e21-8d7d-552b9211ab5f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: familias de polinomios", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, 3.9678142870009956`*^9, {3.9678146428878593`*^9, 
   3.967814647381794*^9}},ExpressionUUID->"401ee21d-f3bf-244a-9df9-\
a65d1aba2388"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"2", "*", "x"}], "+", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "15"}], ",", "15"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "30"}], ",", 
   RowBox[{"framesxSeg", "=", "10"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{"xmax", "=", "2"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "15"}]}], ",", 
   RowBox[{"ymax", "=", "15"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "3"}], "+", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "2"}]}], "-", 
         RowBox[{"2", "*", "x"}], "+", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], "}"}], 
    ",", "\"\<animation4.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, {3.967814362981798*^9, 3.9678143634291744`*^9}, {
   3.967814661447994*^9, 3.9678146907746525`*^9}, {3.9678147423601627`*^9, 
   3.96781476472674*^9}, {3.967830580958302*^9, 3.9678305831596127`*^9}, {
   3.967833189517655*^9, 3.967833199962275*^9}, {3.967979732775722*^9, 
   3.967979740500164*^9}, {3.9679802145696707`*^9, 3.967980216064639*^9}, {
   3.96798024630856*^9, 3.967980269553215*^9}, 3.9679803340492992`*^9, 
   3.9679809312933893`*^9, 
   3.970746101459074*^9},ExpressionUUID->"cf374627-f179-474b-98a5-\
f6c08046f5ec"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = -3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], -3, 3, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {227.50512637308728`, 238.96899356058728`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = -3}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      Plot[$CellContext`x^3 + $CellContext`a$$ $CellContext`x^2 - 
        2 $CellContext`x + 1, {$CellContext`x, -2, 2}, 
        PlotRange -> {-15, 15}], 
      "Specifications" :> {{$CellContext`a$$, -3, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {318.8459772031654, 330.3098443906654}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.967814765563078*^9, 3.9678304982012453`*^9, 3.9678305914043007`*^9, {
   3.9679801913725443`*^9, 3.967980217045183*^9}, {3.96798025250758*^9, 
   3.96798027646574*^9}, 3.9679803147248993`*^9, 3.967980592349827*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"fc278b96-ab22-473d-9ef3-a754ffab8290"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"30", ",", "10", ",", "True", ",", "\<\"orange\"\>", ",", "True", ",", 
   RowBox[{"-", "2"}], ",", "2", ",", 
   RowBox[{"-", "15"}], ",", "15", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{
  3.967814765563078*^9, 3.9678304982012453`*^9, 3.9678305914043007`*^9, {
   3.9679801913725443`*^9, 3.967980217045183*^9}, {3.96798025250758*^9, 
   3.96798027646574*^9}, 3.9679803147248993`*^9, 3.967980592381225*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"4bf1bc5e-b17a-47b6-b02e-f4f661f2f67e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.967980592726262*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"da0e2357-2f59-4da5-917d-6b0e069ff1b7"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.9679805927267857`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"6bb137f6-7cbf-45e0-a58e-bf342cb736d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.967980592727474*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"883b0e57-3035-43a3-a671-5ffcc374e0c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.967980592727862*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"7a5f4733-ead8-4ea7-bce8-25ca95329034"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.967980592728249*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"0acfc98f-3bf8-414d-91c7-1d975b32ea7f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.9679805927965803`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"b052e9ba-320d-4ba6-b489-146d48217530"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.9679805938014717`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"16fc118f-905c-45e8-8dd4-a6302af6d719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation4/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.9679805938040047`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"89dad0a5-db65-4466-a4ea-c3edf93faecf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation4\"\>"}],
  SequenceForm["Archivo: ", "animation4"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.9679805938062677`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"8ded3fe4-2ddb-47c6-b2f7-44fb69af84ca"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.967980600039792*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"4cf087b9-e909-4eb7-85e6-ae0a128b838f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation4/animation4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation4/animation4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967814766278063*^9, 3.967830498561575*^9, 3.96783059175718*^9, {
   3.967980191754891*^9, 3.9679802174233303`*^9}, {3.967980252887738*^9, 
   3.9679802768401947`*^9}, 3.967980315099928*^9, 3.967980600040513*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[47]:=",ExpressionUUID->"d10b3484-ceac-4301-8549-dece5884ad33"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation4/\
animation4.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967814765563078*^9, 3.9678304982012453`*^9, 3.9678305914043007`*^9, {
   3.9679801913725443`*^9, 3.967980217045183*^9}, {3.96798025250758*^9, 
   3.96798027646574*^9}, 3.9679803147248993`*^9, 3.967980600054461*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"76032890-dcca-45f8-b274-1ec91b58042a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: exponencial vs logaritmo", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, 3.9678142923569736`*^9, 3.9678148077505684`*^9, {
   3.967830633633617*^9, 3.967830643324963*^9}, 
   3.9678310006211147`*^9},ExpressionUUID->"d12a79f1-0cde-a640-9bca-\
d317b1c56135"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "*", 
        RowBox[{"Exp", "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "t"}], ")"}], "*", 
        RowBox[{"Log", "[", 
         RowBox[{"x", "+", "0.1"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "10"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "40"}], ",", 
   RowBox[{"framesxSeg", "=", "6"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{"xmax", "=", "5"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{"ymax", "=", "10"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "*", 
           RowBox[{"Exp", "[", "x", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "t"}], ")"}], "*", 
           RowBox[{"Log", "[", 
            RowBox[{"x", "+", "0.1"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2"}], "}"}], "}"}], 
    ",", "\"\<animation5.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, 3.967814369200983*^9, {3.967830662023532*^9, 
   3.9678306917255497`*^9}, {3.967830753330494*^9, 3.967830796259057*^9}, {
   3.967830896409384*^9, 3.967830912127849*^9}, {3.967833175177557*^9, 
   3.967833182644116*^9}, {3.9679797466800537`*^9, 3.967979752937752*^9}, 
   3.96798035714895*^9, {3.9679806676726017`*^9, 3.967980668480144*^9}, 
   3.967980938526532*^9, 
   3.970746108226042*^9},ExpressionUUID->"ed3dc65a-a562-174c-923e-\
7e7a8e35972e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {222.13089603734855`, 233.59476322484855`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      Plot[{$CellContext`t$$ Exp[$CellContext`x] + (1 - $CellContext`t$$) 
          Log[$CellContext`x + 0.1]}, {$CellContext`x, -2, 5}, 
        PlotRange -> {-3, 10}], 
      "Specifications" :> {{$CellContext`t$$, 0, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {313.47174686742665`, 324.93561405492665`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967830708327692*^9, 3.967830802481412*^9, 
  3.967830835069502*^9, 3.967830918312254*^9, 3.967980616051346*^9, 
  3.967980677624386*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"46ed071a-76d5-48ae-8bd5-f8f7e44a8782"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", "6", ",", "False", ",", "\<\"green\"\>", ",", "True", ",", 
   RowBox[{"-", "2"}], ",", "5", ",", 
   RowBox[{"-", "3"}], ",", "10", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.967830708327692*^9, 3.967830802481412*^9, 
  3.967830835069502*^9, 3.967830918312254*^9, 3.967980616051346*^9, 
  3.9679806776506557`*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"0d8e0cbf-a357-456a-bce3-365c55c990ea"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.967980677957797*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"c94a2f6f-87a7-4145-9fff-1aa54e0e7007"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.967980677958331*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"0f69c2a0-b270-48a2-9b82-e5d3882ded57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.967980677959046*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"c2be54b3-3dc7-41f5-91db-6d6fbb59215f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.967980677959462*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"4220abfc-0112-4184-b2c2-6462339ab874"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.96798067795986*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"cf81e7e0-1d1a-4e40-bddd-21617bc67791"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.967980678020321*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"a2ce6661-290e-454e-bd01-9a98d2174f45"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.967980679026455*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"f4777feb-b67d-44aa-bcc0-f55ac2128cac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation5/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.96798067902993*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"f2f0aed1-d1ad-4bf1-8a12-4146b41a08bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation5\"\>"}],
  SequenceForm["Archivo: ", "animation5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.9679806790324306`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"39545b03-0928-4f51-9399-7459bdd4b685"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.96798068362403*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"5ffd4232-b3f6-48be-8f77-9f8e1d81a3a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation5/animation5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation5/animation5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967830708581761*^9, 3.967830802774477*^9, 
  3.967830835354383*^9, 3.967830918626326*^9, 3.96798061638087*^9, 
  3.967980683624761*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[55]:=",ExpressionUUID->"f30db64c-ef5f-4978-bc81-cc7de72aab8a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation5/\
animation5.pdf\"\>"], "Output",
 CellChangeTimes->{3.967830708327692*^9, 3.967830802481412*^9, 
  3.967830835069502*^9, 3.967830918312254*^9, 3.967980616051346*^9, 
  3.967980683638237*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"f3c14aa2-84a7-4a0e-9d9d-b6538510939f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: c\[IAcute]rculos conc\[EAcute]ntricos", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, 3.967814296737526*^9, 3.967814819816698*^9, {
   3.967831031459854*^9, 
   3.967831036907283*^9}},ExpressionUUID->"73e8f9a8-2746-cf40-baf9-\
aeafc07aabe8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "*", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"r", "*", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3.5"}], ",", "3.5"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0.1", ",", "3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "40"}], ",", 
   RowBox[{"framesxSeg", "=", "6"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "3.5"}]}], ",", 
   RowBox[{"xmax", "=", "3.5"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "3.5"}]}], ",", 
   RowBox[{"ymax", "=", "3.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "r", "}"}], ",", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", "*", 
           RowBox[{"Cos", "[", "t", "]"}]}], ",", 
          RowBox[{"r", "*", 
           RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0.1", ",", "3"}], "}"}], "}"}], 
    ",", "\"\<animation6.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, 3.9678143733607407`*^9, {3.967831052305745*^9, 
   3.9678311125447903`*^9}, {3.9678331554674397`*^9, 3.967833165260676*^9}, {
   3.967979759955596*^9, 3.967979765009755*^9}, 3.967980361828484*^9, {
   3.967980786805909*^9, 3.967980787827155*^9}, 3.967980943970735*^9, 
   3.970746113339924*^9},ExpressionUUID->"c53fa6f5-3839-b84b-9518-\
e924d7057c45"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`r$$ = 0.1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`r$$], 0.1, 3, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {318.41806640625, 329.88193359375}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`r$$ = 0.1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      ParametricPlot[{$CellContext`r$$ Cos[$CellContext`t], $CellContext`r$$ 
         Sin[$CellContext`t]}, {$CellContext`t, 0, 2 Pi}, 
        PlotRange -> {-3.5, 3.5}], 
      "Specifications" :> {{$CellContext`r$$, 0.1, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {409.7589172363281, 421.2227844238281}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967831130609606*^9, 3.967980702113673*^9, 
  3.967980739545148*^9, 3.967980803445139*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"d65202ae-ffea-4a2e-84c4-45ca22a23843"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", "6", ",", "True", ",", "\<\"purple\"\>", ",", "True", ",", 
   RowBox[{"-", "3.5`"}], ",", "3.5`", ",", 
   RowBox[{"-", "3.5`"}], ",", "3.5`", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.967831130609606*^9, 3.967980702113673*^9, 
  3.967980739545148*^9, 3.967980803474965*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"d6264221-ad35-4070-a8f5-e5eb7f4869f0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.9679808042323093`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"e59e17d2-8d55-46c2-ac33-efd50c5d27df"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.96798080423284*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"1ed70ab0-bacb-42e8-ac77-fa7ee34fc500"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.96798080423349*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"74face42-5df9-46f7-aa65-b1a17751ba54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.9679808042338743`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"2271242a-0f34-4733-bd74-536d6ea2e746"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.9679808042342567`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"20c8fb9e-0f60-4d48-8819-83a9175e8452"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.967980804296844*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"78f08df9-c201-4ef2-a161-e49500dbcaed"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.9679808053026743`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"4e36c052-f53c-4b95-a83e-c54760946b5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation6/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation6/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.967980805306243*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"988a1bd8-6860-4ae7-bfd4-b0b6dc7b6cfb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation6\"\>"}],
  SequenceForm["Archivo: ", "animation6"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.967980805308763*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"352099f4-83dc-48e6-bc1c-ef155429cf3b"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.967980821493347*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"595b6032-fad1-45b6-ae96-63e1b2b70bfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation6/animation6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation6/animation6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967831131376542*^9, 3.967980702901352*^9, 
  3.967980740340706*^9, 3.967980821494062*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[67]:=",ExpressionUUID->"4d2b35d1-0b65-4da7-bb69-fb8aa27a7ee6"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation6/\
animation6.pdf\"\>"], "Output",
 CellChangeTimes->{3.967831130609606*^9, 3.967980702113673*^9, 
  3.967980739545148*^9, 3.967980821509226*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"5f3a47c2-39ca-4a39-b8f9-a05181de4ce9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 7: curvas param\[EAcute]tricas", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, 3.9678143013566895`*^9, 3.9678148352531013`*^9, {
   3.967831188085493*^9, 
   3.967831194188047*^9}},ExpressionUUID->"bb14fcf3-836c-6943-9006-\
c04d5b60962e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"ratio", "*", "t"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ratio", ",", "1", ",", "4"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "40"}], ",", 
   RowBox[{"framesxSeg", "=", "10"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{"xmax", "=", "2"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{"ymax", "=", "2"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "ratio", "}"}], ",", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"ratio", "*", "t"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"ratio", ",", "1", ",", "4"}], "}"}], "}"}], 
    ",", "\"\<animation7.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, 3.9678143768300457`*^9, {3.967831210488065*^9, 
   3.96783129709726*^9}, {3.967831539969352*^9, 3.967831558542342*^9}, {
   3.967831623047146*^9, 3.967831629960588*^9}, {3.967833138003684*^9, 
   3.967833145941156*^9}, {3.967979773368235*^9, 3.967979779333321*^9}, 
   3.96798036813238*^9, 3.9679809497835608`*^9, 
   3.9707461206736803`*^9},ExpressionUUID->"29e52fed-f6d5-4e49-aa80-\
0e1f1644af86"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`ratio$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`ratio$$], 1, 4, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {328.58994140625, 340.05380859375}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`ratio$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> ParametricPlot[{
         Sin[$CellContext`t], 
         Sin[$CellContext`ratio$$ $CellContext`t]}, {$CellContext`t, 0, 2 Pi},
         PlotRange -> {-2, 2}], 
      "Specifications" :> {{$CellContext`ratio$$, 1, 4}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {419.9307922363281, 431.3946594238281}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967831301293442*^9, 3.967831360560363*^9, 
  3.967831565786703*^9, 3.967832079151123*^9, 3.9679808274702597`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"c8a90d1c-438b-4a5f-ac7b-0073f6cd03d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", "10", ",", "True", ",", "\<\"gray\"\>", ",", "True", ",", 
   RowBox[{"-", "2"}], ",", "2", ",", 
   RowBox[{"-", "2"}], ",", "2", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.967831301293442*^9, 3.967831360560363*^9, 
  3.967831565786703*^9, 3.967832079151123*^9, 3.967980827496479*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"2a7db521-691d-4d99-b7b3-ff9e0a9aecc9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.96798082829972*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"0c379fac-a588-41e1-bf2a-cc12ab41f29f"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.967980828300253*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"91d22a41-fea9-469d-8444-5f8809287052"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.967980828300915*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"f3b2bbf0-cfc1-4b0b-94bb-0ae71796b877"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.96798082830131*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"5ccc30c2-6d1a-4652-9f50-64f8d2e80fa4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.9679808283017063`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"3d26e66d-77db-4c99-afc1-fe08b76db0a8"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.967980828366798*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"fd5f8b16-eca4-42fe-9287-8d634455b5f6"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.9679808293727293`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"1682e13d-8f01-4cf4-bf1f-057a3904e646"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation7/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation7/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.9679808293751173`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"207f6ac5-09e2-4de6-a3b4-4e318e705241"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation7\"\>"}],
  SequenceForm["Archivo: ", "animation7"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.96798082937685*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"f5e34511-7af9-49ff-bfe2-eba56872751d"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.967980846263932*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"0ac46dd9-5011-4d46-9d07-dbd05cc701d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation7/animation7.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation7/animation7.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678313013866243`*^9, 3.967831360650138*^9, 
  3.967831566581252*^9, 3.967832079949707*^9, 3.967980846264638*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[71]:=",ExpressionUUID->"d044066a-1af7-43fa-b0eb-1b97b6b3d58f"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation7/\
animation7.pdf\"\>"], "Output",
 CellChangeTimes->{3.967831301293442*^9, 3.967831360560363*^9, 
  3.967831565786703*^9, 3.967832079151123*^9, 3.967980846278741*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"bcfe5a91-4fab-4170-a5d0-c072967cb915"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 8: funci\[OAcute]n gaussiana", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, 3.9678143056934013`*^9, 3.9678148502751255`*^9, {
   3.967832248194099*^9, 
   3.96783225591538*^9}},ExpressionUUID->"67700722-0f36-af40-b3fb-\
8482efc23e9a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", 
          RowBox[{"sigma", "^", "2"}]}], ")"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "\[Pi]", "*", 
        RowBox[{"sigma", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "0.8"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"sigma", ",", "0.3", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "40"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "6"}]}], ",", 
   RowBox[{"xmax", "=", "6"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "0.5"}]}], ",", 
   RowBox[{"ymax", "=", "0.8"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "sigma", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"x", "^", "2"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"sigma", "^", "2"}]}], ")"}]}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"2", "\[Pi]", "*", 
           RowBox[{"sigma", "^", "2"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"sigma", ",", "0.3", ",", "2"}], "}"}], "}"}], 
    ",", "\"\<animation8.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, 3.9678143801885815`*^9, {3.967832268358176*^9, 
   3.967832305380055*^9}, {3.967832337674217*^9, 3.96783234620805*^9}, {
   3.9678324091706657`*^9, 3.96783242649255*^9}, {3.967832465650827*^9, 
   3.9678324786481447`*^9}, {3.967832540495479*^9, 3.9678325467521753`*^9}, {
   3.96783276467883*^9, 3.967832788261427*^9}, {3.967832875131784*^9, 
   3.967832875695272*^9}, {3.967832916533704*^9, 3.967832924687079*^9}, {
   3.967979785891045*^9, 3.967979791171466*^9}, 3.967980373122954*^9, {
   3.9679809564440403`*^9, 3.967980956854826*^9}, 
   3.970746125731406*^9},ExpressionUUID->"50e32df0-ccbf-a540-93b3-\
a8eb61b0c091"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`sigma$$ = 0.3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`sigma$$], 0.3, 2, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {222.41918887308728`, 233.88305606058728`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`sigma$$ = 0.3}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      Plot[Exp[(-$CellContext`x^2)/(2 $CellContext`sigma$$^2)]/Sqrt[
        2 Pi $CellContext`sigma$$^2], {$CellContext`x, -6, 6}, 
        PlotRange -> {-0.5, 0.8}], 
      "Specifications" :> {{$CellContext`sigma$$, 0.3, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {313.7600397031654, 325.2239068906654}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.967832353834094*^9, 3.967832434183194*^9, 3.9678324795407133`*^9, 
   3.967832550760913*^9, 3.967832789292728*^9, 3.9678328766655617`*^9, {
   3.9678329173648987`*^9, 3.967832934276425*^9}, 3.967981058203524*^9, 
   3.967981097893385*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"d4fdf28a-77ac-46e0-93ef-09855e294f3e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", "8", ",", "True", ",", "\<\"black\"\>", ",", "True", ",", 
   RowBox[{"-", "6"}], ",", "6", ",", 
   RowBox[{"-", "0.5`"}], ",", "0.8`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.967832353834094*^9, 3.967832434183194*^9, 3.9678324795407133`*^9, 
   3.967832550760913*^9, 3.967832789292728*^9, 3.9678328766655617`*^9, {
   3.9678329173648987`*^9, 3.967832934276425*^9}, 3.967981058203524*^9, 
   3.9679810979184217`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"fa9a14d6-921c-46a4-8408-373e9b3c7abd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.967981098628351*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"1f2cbd54-5970-47e5-8edc-859a8bbb2809"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.967981098628869*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"a5a2079b-c62b-4603-bdea-09c6d5468291"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.967981098629546*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"481625e1-d6c0-42c2-ab2b-b5e4a820ce6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.967981098629928*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"7c3280a5-6ca1-4787-a8d3-9bbe7983fa8b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.96798109863031*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"6bb8d36e-87a6-4856-9b25-388fb8c564a8"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.9679810986956053`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"a859e5cd-9f04-458e-92f3-ee71b302a752"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.9679810997022257`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"f834dd25-fe40-4f1f-ac85-df2105294337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation8/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation8/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.967981099705051*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"0c528580-00e6-4807-a372-37d9dbbacb64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation8\"\>"}],
  SequenceForm["Archivo: ", "animation8"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.967981099707609*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"3a93f1d7-7aa7-4a47-89f0-e6cd8293480b"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.967981116999106*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"1d6faf26-2682-4df2-82ca-13f06865a21e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation8/animation8.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation8/animation8.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967832354432437*^9, 3.967832434763342*^9, 3.96783248025869*^9, 
   3.967832551480476*^9, 3.967832790005093*^9, 3.967832877377215*^9, {
   3.967832918080448*^9, 3.967832934992464*^9}, 3.967981058945612*^9, 
   3.9679811169999332`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[79]:=",ExpressionUUID->"c484d488-254e-4919-956f-a27ceb44043a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation8/\
animation8.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967832353834094*^9, 3.967832434183194*^9, 3.9678324795407133`*^9, 
   3.967832550760913*^9, 3.967832789292728*^9, 3.9678328766655617`*^9, {
   3.9678329173648987`*^9, 3.967832934276425*^9}, 3.967981058203524*^9, 
   3.967981117015668*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"3463adb1-d422-4bc2-ab5c-4ea7fbba8ab2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 9: onda sinusoidal", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, 3.9678143097583466`*^9, 3.967814864398592*^9, {
   3.967833060673523*^9, 
   3.967833066075741*^9}},ExpressionUUID->"45a86fcb-8a37-a848-a9e9-\
b490f25f1969"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", "\[Pi]", "*", 
       RowBox[{"(", 
        RowBox[{"x", "-", "t"}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "50"}], ",", 
   RowBox[{"framesxSeg", "=", "12"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "4"}]}], ",", 
   RowBox[{"xmax", "=", "4"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.5"}]}], ",", 
   RowBox[{"ymax", "=", "1.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"2", "\[Pi]", "*", 
          RowBox[{"(", 
           RowBox[{"x", "-", "t"}], ")"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "2"}], "}"}], "}"}], 
    ",", "\"\<animation9.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, 3.9678143836974716`*^9, {3.9678330795902987`*^9, 
   3.967833111933034*^9}, {3.967833321353126*^9, 3.967833361707309*^9}, {
   3.9679797963161697`*^9, 3.967979803546941*^9}, 3.9679803775188313`*^9, {
   3.96798096264439*^9, 3.967980963033143*^9}, 
   3.9707461321199913`*^9},ExpressionUUID->"4cd313f8-c1f4-4649-a306-\
2f7c2d7acca0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {227.5051263730873, 238.9689935605873}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Plot[
        Sin[
        2 Pi ($CellContext`x - $CellContext`t$$)], {$CellContext`x, -4, 4}, 
        PlotRange -> {-1.5, 1.5}], 
      "Specifications" :> {{$CellContext`t$$, 0, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {318.84597720316543`, 330.30984439066543`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.9678332557618504`*^9, 3.967833370365554*^9, 
  3.967981147571677*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"4dbec2e0-54f4-4ab2-bba9-35d151815c74"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"50", ",", "12", ",", "False", ",", "\<\"green\"\>", ",", "True", ",", 
   RowBox[{"-", "4"}], ",", "4", ",", 
   RowBox[{"-", "1.5`"}], ",", "1.5`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.9678332557618504`*^9, 3.967833370365554*^9, 
  3.967981147601267*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"f50f2eb8-9a14-4555-b660-6bb7e7fa5e1c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981149102007*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"d26240d3-70a6-4400-8334-cb7b7c7af6b2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.96798114910254*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"8f7bba26-fe99-4ef7-8b9c-aecc6c5853ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981149103236*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"95066ac7-d02f-44e3-b463-02e193ec4ea1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981149103629*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"7171cd7a-b8f6-44cd-a931-d43ec59c4e91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981149104019*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"cbf41dcb-a9ac-4b4b-8ec2-8ea7cb16a0cd"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981149164*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"ca2f3cf8-c5e2-4a0e-91e1-2076e130cfbb"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981150169836*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"d762502d-7820-40f8-86c5-3b22eaa72207"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation9/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation9/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981150172106*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"166647d3-f355-4360-95cd-e5376af85bc1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation9\"\>"}],
  SequenceForm["Archivo: ", "animation9"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981150174387*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"313d2937-18cb-45df-a6df-d35977f6ef33"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.967981193199623*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"ecd6825a-7279-47c9-b7ce-299a22fc4556"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation9/animation9.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation9/animation9.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678332568843946`*^9, 3.967833371871705*^9, 
  3.9679811932004557`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[83]:=",ExpressionUUID->"a6c8dcb6-86a1-4a1c-b7b9-63ae486e99fd"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation9/\
animation9.pdf\"\>"], "Output",
 CellChangeTimes->{3.9678332557618504`*^9, 3.967833370365554*^9, 
  3.9679811932177896`*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"6a958d09-710c-4b81-9585-e448a24e4020"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 10: de seno a coseno pasando por fases intermedias", \
"Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.9678143137765865`*^9, 3.9678143139708652`*^9}, 
   3.9678148795773296`*^9, {3.9678785300903587`*^9, 
   3.967878532338429*^9}},ExpressionUUID->"d31d0313-5114-fc44-9b6b-\
825cbaeedb98"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "phase"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"-", "4"}], "\[Pi]"}], ",", 
       RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"phase", ",", "0", ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "25"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{
     RowBox[{"-", "4"}], "\[Pi]"}]}], ",", 
   RowBox[{"xmax", "=", 
    RowBox[{"4", "\[Pi]"}]}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.5"}]}], ",", 
   RowBox[{"ymax", "=", "1.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "phase", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", "+", "phase"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"-", "4"}], "\[Pi]"}], ",", 
          RowBox[{"4", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"phase", ",", "0", ",", 
       RowBox[{"\[Pi]", "/", "2"}]}], "}"}], "}"}], 
    ",", "\"\<animation10.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, {3.9678143882119255`*^9, 3.9678143884180183`*^9}, {
   3.96787679119489*^9, 3.9678767951580963`*^9}, {3.967878548287071*^9, 
   3.967878675615245*^9}, {3.967979809997923*^9, 3.967979815097237*^9}, 
   3.967980381497364*^9, {3.9679809697086782`*^9, 3.967980970069972*^9}, 
   3.970746138227729*^9},ExpressionUUID->"d593ff76-d2b4-ac47-9d7e-\
50196d11175e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`phase$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`phase$$], 0, Rational[1, 2] Pi, ControlType -> 
      Manipulator}}, Typeset`size$$ = {
    720., {227.5051263730873, 238.9689935605873}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`phase$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Plot[
        Sin[$CellContext`x + $CellContext`phase$$], {$CellContext`x, (-4) Pi, 
         4 Pi}, PlotRange -> {-1.5, 1.5}], 
      "Specifications" :> {{$CellContext`phase$$, 0, Rational[1, 2] Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {318.84597720316543`, 330.30984439066543`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967878653957143*^9, 3.967878715494742*^9, 
  3.9679812120356693`*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"111f7973-9424-4437-abe3-df59a7e69a2b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "25", ",", "8", ",", "False", ",", "\<\"red\"\>", ",", "True", ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "\[Pi]"}], ",", 
   RowBox[{"4", " ", "\[Pi]"}], ",", 
   RowBox[{"-", "1.5`"}], ",", "1.5`", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.967878653957143*^9, 3.967878715494742*^9, 
  3.967981212065295*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"f8b9d007-f558-49da-8609-ec29eaa1ec5a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.9679812126290197`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"9cd61970-7c30-4b71-8a67-3daff0b17cbc"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.9679812126295357`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"a4db2395-9fc2-439d-8c19-c465931afcfc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.96798121263021*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"3e8acbb1-6b4d-4a20-851b-580bc7254e84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.9679812126305923`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"7436fe6c-c024-49fc-874a-0e0841b4f0c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.9679812126309767`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"5f41457f-3980-4c2c-af30-c1f795d54e18"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.967981212697496*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"c55c6159-97c2-4ceb-b6df-9d6a652cd762"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.967981213703432*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"5be09351-5869-497f-98e3-23a3e74a033e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation10/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation10/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.967981213705969*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"14411204-faf1-4887-aa2a-85b75185a871"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation10\"\>"}],
  SequenceForm["Archivo: ", "animation10"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.967981213707966*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"3313acc5-fafc-4c1f-8133-733ad4f8ebba"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.967981225813685*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"b70419f8-5de0-48de-938c-1cbf78f36fb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation10/animation10.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation10/animation10.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967878654525345*^9, 3.967878716071601*^9, 
  3.967981225814443*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[87]:=",ExpressionUUID->"7d96aeaf-407b-420a-8404-a86603557476"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation10/\
animation10.pdf\"\>"], "Output",
 CellChangeTimes->{3.967878653957143*^9, 3.967878715494742*^9, 
  3.96798122582872*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"4d35f5f2-1c8f-4427-98a8-0be49d034226"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 11:  onda con amplitud y frecuencia variables", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, 
   3.967814900911625*^9, {3.967878756153369*^9, 
   3.96787875842661*^9}},ExpressionUUID->"47d7cb90-9883-b44b-9a5f-\
d0586e618d19"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"A", "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "\[Pi]", "*", "f", "*", "x"}], "]"}], "*", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "x"}], "/", "3"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "0.5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "1", ",", "4"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "35"}], ",", 
   RowBox[{"framesxSeg", "=", "10"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "4"}]}], ",", 
   RowBox[{"xmax", "=", "4"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.5"}]}], ",", 
   RowBox[{"ymax", "=", "1.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A", ",", "f"}], "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"A", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Pi]", "*", "f", "*", "x"}], "]"}], "*", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "x"}], "/", "3"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A", ",", "0.5", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "1", ",", "4"}], "}"}]}], "}"}], 
    ",", "\"\<animation11.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678128607282085`*^9, 3.967812888496931*^9}, {
   3.9678129187335377`*^9, 3.967812925814007*^9}, {3.967812963240244*^9, 
   3.9678130308151703`*^9}, {3.967813061743025*^9, 3.967813062236471*^9}, {
   3.9678131552250576`*^9, 3.967813190338833*^9}, {3.9678133382615547`*^9, 
   3.9678133581536694`*^9}, {3.967813514898058*^9, 3.9678135176551533`*^9}, {
   3.9678135582736473`*^9, 3.967813687369276*^9}, {3.9678137741996956`*^9, 
   3.9678138507568455`*^9}, {3.9678140375063114`*^9, 3.9678140915312767`*^9}, 
   3.9678142335903587`*^9, {3.9678143918566914`*^9, 3.967814392009638*^9}, {
   3.967876803888981*^9, 3.9678768043702707`*^9}, {3.967878777328175*^9, 
   3.967878870813877*^9}, {3.9679798224929543`*^9, 3.967979827848523*^9}, 
   3.96798038615924*^9, {3.967980975919465*^9, 3.967980976308145*^9}, {
   3.970746143187134*^9, 
   3.970746144479712*^9}},ExpressionUUID->"a34d9bf1-5fa8-d146-b2e8-\
279225827a60"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`A$$ = 0.5, $CellContext`f$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`A$$], 0.5, 2, ControlType -> Manipulator}, {
      Hold[$CellContext`f$$], 1, 4, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {227.5051263730873, 238.9689935605873}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`A$$ = 0.5, $CellContext`f$$ = 1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      Plot[$CellContext`A$$ Sin[2 Pi $CellContext`f$$ $CellContext`x] 
        Exp[(-$CellContext`x)/3], {$CellContext`x, -4, 4}, 
        PlotRange -> {-1.5, 1.5}], 
      "Specifications" :> {{$CellContext`A$$, 0.5, 2}, {$CellContext`f$$, 1, 
         4}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {348.44597720316546`, 359.90984439066546`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967878878260478*^9, 3.9679812464143953`*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"399b9e4a-4e26-43ac-aa56-96e122309b00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"35", ",", "10", ",", "True", ",", "\<\"orange\"\>", ",", "True", ",", 
   RowBox[{"-", "4"}], ",", "4", ",", 
   RowBox[{"-", "1.5`"}], ",", "1.5`", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.967878878260478*^9, 3.967981246446134*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"16bfffb8-9594-452c-94e6-8c399098b5cd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.967981247890115*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"ed2ef6dc-4156-44a8-a9e7-e6b38d943eb1"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.96798124789062*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"17cd87a5-94f5-4346-b14e-2f397748f6fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.967981247891314*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"e3110ebc-b039-4e97-ae7b-57fa4baca41a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.967981247891721*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"147713f1-7bad-483e-b3db-c14026a487ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.967981247892123*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"f96ad9bd-134f-4fca-83bc-c1df9cea948e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.9679812479581203`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"0fa2643e-9c74-4c63-bb25-43a19fb1f10a"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.967981248964319*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"47d47857-7a10-488f-a16d-5d56ff52eec2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation11/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation11/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.96798124896701*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"818ce0e4-e299-4682-b0d7-5c37d06550e7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation11\"\>"}],
  SequenceForm["Archivo: ", "animation11"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.96798124896905*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"288bbe2d-5900-42e8-a77e-b5f0bcde8520"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.967981281229849*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"104d9ca5-d178-4ea7-89f1-f23b6d808d3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation11/animation11.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation11/animation11.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9678788796966877`*^9, 3.967981281230516*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"f8bb0c56-47e5-4788-b791-5313ef72d457"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation11/\
animation11.pdf\"\>"], "Output",
 CellChangeTimes->{3.967878878260478*^9, 3.967981281244754*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"c95ba954-e214-4ba4-95bb-ac3995753151"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 12:  funci\[OAcute]n escal\[OAcute]n (transici\[OAcute]n suave entre \
dos niveles)\
\>", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, {
   3.967814900911625*^9, 3.9678149230167007`*^9}, 3.9678149593105106`*^9, {
   3.9678789648366537`*^9, 3.967878965703114*^9}, {3.967879136334237*^9, 
   3.967879157829254*^9}},ExpressionUUID->"ac87a7d0-47c4-ba43-9f38-\
d7942f291ff6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{"k", "*", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0.5", ",", "10"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "40"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{"xmax", "=", "2"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.2"}]}], ",", 
   RowBox[{"ymax", "=", "1.2"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "k", "}"}], ",", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{"k", "*", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0.5", ",", "10"}], "}"}], "}"}], 
    ",", "\"\<animation12.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967814963930401*^9, 3.967814963930401*^9}, {
   3.967815412095148*^9, 3.9678154140288677`*^9}, {3.967876808838952*^9, 
   3.967876809394079*^9}, {3.967878963351308*^9, 3.96787904711383*^9}, {
   3.967879077505011*^9, 3.967879079630673*^9}, {3.967879167283506*^9, 
   3.96787918906572*^9}, {3.967879219837749*^9, 3.967879233205719*^9}, {
   3.9679798361131*^9, 3.967979840657035*^9}, 3.967980390525278*^9, {
   3.9679809828192987`*^9, 3.9679809832574863`*^9}, 3.9679813198097763`*^9, 
   3.97074614948999*^9},ExpressionUUID->"d9040454-3060-ec46-abec-\
d61346bf96a3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`k$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`k$$], 0.5, 10, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {217.3332513730873, 228.7971185605873}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`k$$ = 0.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Plot[
        Tanh[$CellContext`k$$ $CellContext`x], {$CellContext`x, -2, 2}, 
        PlotRange -> {-1.2, 1.2}], 
      "Specifications" :> {{$CellContext`k$$, 0.5, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {308.67410220316543`, 320.13796939066543`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.967879083922262*^9, 3.967879194768138*^9, 3.967879713384729*^9, {
   3.9679813018171053`*^9, 3.967981326410736*^9}},
 CellLabel->"Out[99]=",ExpressionUUID->"1fd72677-5f4b-4dda-8dea-eb94ab0b2b90"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "40", ",", "8", ",", "False", ",", "\<\"red\"\>", ",", "True", ",", 
   RowBox[{"-", "2"}], ",", "2", ",", 
   RowBox[{"-", "1.2`"}], ",", "1.2`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.967879083922262*^9, 3.967879194768138*^9, 3.967879713384729*^9, {
   3.9679813018171053`*^9, 3.967981326437622*^9}},
 CellLabel->
  "Out[100]=",ExpressionUUID->"45db458e-bf5e-4a8c-9840-f523919ac9e8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.967981327074706*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"a08c5e6d-f4c4-445a-81d5-d89e00455c2c"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.967981327075218*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"06ff0df4-e1fd-4802-a45f-2abf3983aed8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.967981327075883*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"182fd81a-7e52-470c-8a54-0dd1a7fb24ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.9679813270762587`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"1391fc65-9b77-45d0-b00c-3fd2a9f4a392"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.967981327076635*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"5702d556-989c-42aa-a8df-9424fc9dbf5c"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.967981327138344*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"5902c4d5-29d8-4739-aa1f-addde80d4e41"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.967981328144142*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"9ccfb7bb-5b89-4c44-8e81-d3f1958ca4c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation12/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation12/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.9679813281466923`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"925fdaa7-d8dd-46cb-abc7-c87dc91d2d17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation12\"\>"}],
  SequenceForm["Archivo: ", "animation12"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967879084425486*^9, 3.967879195407523*^9, 3.96787971402276*^9, {
   3.967981302479868*^9, 3.9679813281483593`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"f16db894-bbfd-4dcf-9c82-652bcbfe51d2"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967879084425486*^9, 3.967879195407523*^9, 
  3.96787971402276*^9, 3.967981302479868*^9, 3.967981343525796*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"3bd646ff-d8a4-46be-a46f-3521da557de5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation12/animation12.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation12/animation12.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967879084425486*^9, 3.967879195407523*^9, 
  3.96787971402276*^9, 3.967981302479868*^9, 3.967981343526515*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[99]:=",ExpressionUUID->"f4f573a2-17bb-4067-8874-cb4692295a17"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation12/\
animation12.pdf\"\>"], "Output",
 CellChangeTimes->{3.967879083922262*^9, 3.967879194768138*^9, 
  3.967879713384729*^9, 3.9679813018171053`*^9, 3.967981343541239*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"326cb1c4-4ddb-457a-af67-98c624299b95"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 13: espiral que se expande", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
  3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
  3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, {
  3.967814900911625*^9, 3.967814925506241*^9}, {3.967814983483822*^9, 
  3.967815001528387*^9}, {3.967879778926639*^9, 
  3.967879781107071*^9}},ExpressionUUID->"4b709e95-6340-644c-a84a-\
6656f3603403"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "*", "t", "*", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"a", "*", "t", "*", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "25"}], ",", "35"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "30"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "25"}]}], ",", 
   RowBox[{"xmax", "=", "35"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "25"}]}], ",", 
   RowBox[{"ymax", "=", "35"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "*", "t", "*", 
           RowBox[{"Cos", "[", "t", "]"}]}], ",", 
          RowBox[{"a", "*", "t", "*", 
           RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"4", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], "}"}], 
    ",", "\"\<animation13.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967814980652521*^9, 3.967814980652521*^9}, {
   3.967815417270981*^9, 3.967815417741932*^9}, {3.9678768141918573`*^9, 
   3.9678768145989532`*^9}, {3.967879054767062*^9, 3.967879055051712*^9}, {
   3.967879777555896*^9, 3.9678797867811937`*^9}, 3.967880007662437*^9, {
   3.967914075774534*^9, 3.967914142509285*^9}, {3.9679141840132113`*^9, 
   3.9679141871151733`*^9}, {3.967914250199404*^9, 3.9679142652278757`*^9}, {
   3.967914298719101*^9, 3.967914323025372*^9}, {3.967914373487059*^9, 
   3.967914433723605*^9}, {3.967914464911799*^9, 3.967914474689143*^9}, {
   3.967914520686407*^9, 3.96791452912292*^9}, {3.967914586223174*^9, 
   3.967914588499119*^9}, {3.967914626123929*^9, 3.967914637181329*^9}, {
   3.967914744103095*^9, 3.967914748288457*^9}, {3.967914792377742*^9, 
   3.967914795468032*^9}, {3.967914867488694*^9, 3.967914870710223*^9}, {
   3.967914935288528*^9, 3.967914938530819*^9}, {3.9679798471843853`*^9, 
   3.967979852270835*^9}, 3.967980394423678*^9, {3.9679809881736603`*^9, 
   3.967980988536563*^9}, 
   3.97074615514467*^9},ExpressionUUID->"eeb0b29a-10f3-2241-b71d-\
46c2445c754e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = -3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], -3, 3, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {318.41806640625, 329.88193359375}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = -3}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      ParametricPlot[{$CellContext`a$$ $CellContext`t 
         Cos[$CellContext`t], $CellContext`a$$ $CellContext`t 
         Sin[$CellContext`t]}, {$CellContext`t, 0, 4 Pi}, 
        PlotRange -> {-25, 35}], 
      "Specifications" :> {{$CellContext`a$$, -3, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {409.7589172363281, 421.2227844238281}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.9679141550696077`*^9, 3.96791427602907*^9, 3.96791441266663*^9, 
   3.96791444875495*^9, 3.9679144833990917`*^9, 3.967914529948864*^9, {
   3.9679146426549377`*^9, 3.967914662375904*^9}, 3.967914752319109*^9, 
   3.967914800939837*^9, 3.967914879279956*^9, 3.967914944068622*^9, 
   3.967981361549008*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"82401e4b-1bea-443d-948e-9e309c65535a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "30", ",", "8", ",", "False", ",", "\<\"red\"\>", ",", "True", ",", 
   RowBox[{"-", "25"}], ",", "35", ",", 
   RowBox[{"-", "25"}], ",", "35", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9679141550696077`*^9, 3.96791427602907*^9, 3.96791441266663*^9, 
   3.96791444875495*^9, 3.9679144833990917`*^9, 3.967914529948864*^9, {
   3.9679146426549377`*^9, 3.967914662375904*^9}, 3.967914752319109*^9, 
   3.967914800939837*^9, 3.967914879279956*^9, 3.967914944068622*^9, 
   3.967981361576027*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"bca64907-bc8f-433b-803c-d99b84b35b05"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981362364468*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"c1704990-1e5c-4b37-b776-2e2286f21f1b"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981362364991*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"c7d4bede-e133-40ad-a92d-5ddc5b0a9140"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981362365612*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"ade858b4-b834-4b6b-8511-3387db892499"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981362365985*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"b6094867-98fd-492d-b1c8-cdf4f0a19cb0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981362366356*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"ee71277e-b959-45c7-aa87-8c648e7b33d9"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981362426794*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"edda51a4-1863-4276-a8ca-9a76f331d1de"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981363431926*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"5c7737c6-69d2-4d7f-8db7-a1d01fac4685"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation13/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation13/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.96798136343511*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"2b65319c-759e-49f8-a182-fe1aad0e571c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation13\"\>"}],
  SequenceForm["Archivo: ", "animation13"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.96798136343708*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"e65e82a2-a870-415d-b4ae-912dc0060479"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.96798138116428*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"f2f91b1b-1369-4af0-93d8-08480baa8007"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation13/animation13.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation13/animation13.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967914156668557*^9, 3.9679142776544647`*^9, 3.967914413769724*^9, 
   3.967914449853944*^9, 3.9679144842219353`*^9, 3.9679145307760143`*^9, {
   3.967914643484576*^9, 3.967914663178677*^9}, 3.967914753144225*^9, 
   3.96791480176191*^9, 3.967914880097115*^9, 3.9679149448888693`*^9, 
   3.967981381165017*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[103]:=",ExpressionUUID->"f2159653-ff41-486a-9dd4-955cf86785a7"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation13/\
animation13.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9679141550696077`*^9, 3.96791427602907*^9, 3.96791441266663*^9, 
   3.96791444875495*^9, 3.9679144833990917`*^9, 3.967914529948864*^9, {
   3.9679146426549377`*^9, 3.967914662375904*^9}, 3.967914752319109*^9, 
   3.967914800939837*^9, 3.967914879279956*^9, 3.967914944068622*^9, 
   3.967981381179839*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"623f54b9-a34d-4069-9d6e-bf8ab2ba1644"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 14:  cardioide con tama\[NTilde]o variable", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, {
   3.967814900911625*^9, 3.96781492829653*^9}, 3.9678150141444855`*^9, {
   3.967880022531959*^9, 
   3.967880024101027*^9}},ExpressionUUID->"f97493c9-2e91-446e-b310-\
f58f5aeadca9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Cos", "[", "t", "]"}]}], ")"}], "*", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"r", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Cos", "[", "t", "]"}]}], ")"}], "*", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "4.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.7"}], ",", "2.7"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"r", ",", "0.5", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "25"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "0.5"}]}], ",", 
   RowBox[{"xmax", "=", "4.2"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "2.7"}]}], ",", 
   RowBox[{"ymax", "=", "2.7"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "r", "}"}], ",", 
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"Cos", "[", "t", "]"}]}], ")"}], "*", 
           RowBox[{"Cos", "[", "t", "]"}]}], ",", 
          RowBox[{"r", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"Cos", "[", "t", "]"}]}], ")"}], "*", 
           RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"r", ",", "0.5", ",", "2"}], "}"}], "}"}], 
    ",", "\"\<animation14.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96791504203823*^9, 3.967915095797496*^9}, {
   3.9679151474478207`*^9, 3.967915178556909*^9}, {3.967915229742815*^9, 
   3.9679152456285057`*^9}, {3.96791528155518*^9, 3.9679153069938*^9}, {
   3.967915371391314*^9, 3.967915371574716*^9}, {3.967915411099378*^9, 
   3.9679154208630457`*^9}, 3.9679154580835752`*^9, {3.967915552180471*^9, 
   3.967915563984288*^9}, {3.967915660305678*^9, 3.967915689721876*^9}, {
   3.96791572580717*^9, 3.967915768282977*^9}, {3.9679798608378353`*^9, 
   3.967979866596843*^9}, 3.967980399569755*^9, {3.967980993966771*^9, 
   3.9679809943580647`*^9}, 
   3.9707461603824587`*^9},ExpressionUUID->"3bdc12d9-4db7-40bf-bc39-\
30cdb73b7340"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`r$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`r$$], 0.5, 2, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {407.6616834275266, 419.1255506150266}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`r$$ = 0.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> 
      ParametricPlot[{$CellContext`r$$ (1 + Cos[$CellContext`t]) 
         Cos[$CellContext`t], $CellContext`r$$ (1 + Cos[$CellContext`t]) 
         Sin[$CellContext`t]}, {$CellContext`t, 0, 2 Pi}, 
        PlotRange -> {{-0.5, 4.2}, {-2.7, 2.7}}], 
      "Specifications" :> {{$CellContext`r$$, 0.5, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {499.00253425760474`, 510.46640144510474`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967915114335559*^9, 3.967915188029274*^9, 
  3.967915248535686*^9, 3.9679152843339853`*^9, 3.967915372634097*^9, 
  3.967915425049675*^9, 3.967915463345537*^9, 3.967915564915387*^9, 
  3.967915690662569*^9, 3.967915738521448*^9, 3.9679157687286177`*^9, 
  3.967981427139955*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"1a4fc75d-12c7-449c-ac5b-323cc7b18888"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "25", ",", "8", ",", "False", ",", "\<\"red\"\>", ",", "True", ",", 
   RowBox[{"-", "0.5`"}], ",", "4.2`", ",", 
   RowBox[{"-", "2.7`"}], ",", "2.7`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.967915114335559*^9, 3.967915188029274*^9, 
  3.967915248535686*^9, 3.9679152843339853`*^9, 3.967915372634097*^9, 
  3.967915425049675*^9, 3.967915463345537*^9, 3.967915564915387*^9, 
  3.967915690662569*^9, 3.967915738521448*^9, 3.9679157687286177`*^9, 
  3.9679814271689034`*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"5e13edbf-4513-46ef-a6df-c5e463678854"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981427722826*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"1ed12a93-b868-4567-9176-5076409d9255"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.9679814277233353`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"f5d0cc4c-6508-42dc-a4b4-61ca68093a29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981427723959*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"a51d6856-73f2-4296-b177-5bb7b7190d99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981427724334*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"2f5c3bef-22e9-4705-b164-79835d19558b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981427724709*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"d79d2acc-f272-42ab-b5d7-36a66bf32ab2"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.9679814277942333`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"a1dab5f6-0155-49e4-9ea8-4d38c3527728"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981428800336*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"45948d31-9297-447a-b3db-3c14f0fe1089"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation14/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation14/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981428803865*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"0443a5d9-feff-4c16-8b17-b9e70fb1836f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation14\"\>"}],
  SequenceForm["Archivo: ", "animation14"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981428806241*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"e0d7dff8-6847-4ce1-bad6-cbf09b4418d8"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.9679814441190557`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"1cb994b6-b4f2-4aa9-b3e1-b737c753fd80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation14/animation14.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation14/animation14.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967915114914382*^9, 3.9679151886058826`*^9, 
  3.967915249117886*^9, 3.967915284910329*^9, 3.967915373218841*^9, 
  3.967915425628394*^9, 3.967915463926383*^9, 3.9679155654921*^9, 
  3.967915691242206*^9, 3.967915739096717*^9, 3.967915769304943*^9, 
  3.967981444119816*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[107]:=",ExpressionUUID->"ce20512c-e4ff-4a91-afaf-05063e83952f"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation14/\
animation14.pdf\"\>"], "Output",
 CellChangeTimes->{3.967915114335559*^9, 3.967915188029274*^9, 
  3.967915248535686*^9, 3.9679152843339853`*^9, 3.967915372634097*^9, 
  3.967915425049675*^9, 3.967915463345537*^9, 3.967915564915387*^9, 
  3.967915690662569*^9, 3.967915738521448*^9, 3.9679157687286177`*^9, 
  3.9679814441340446`*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"7585a43a-6775-4fd2-8279-850397a9a3c4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 15:  rosa polar con p\[EAcute]talos variables", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, {
   3.967814900911625*^9, 3.96781492829653*^9}, 3.9678150141444855`*^9, {
   3.9678800389811287`*^9, 
   3.9678800432398148`*^9}},ExpressionUUID->"f439aa4f-213c-bf40-838a-\
258ab3e0ddf4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", "*", "\[Theta]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "8"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "30"}], ",", 
   RowBox[{"framesxSeg", "=", "6"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "1.2"}]}], ",", 
   RowBox[{"xmax", "=", "1.2"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.2"}]}], ",", 
   RowBox[{"ymax", "=", "1.2"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{"PolarPlot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"n", "*", "\[Theta]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", "0", ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"n", ",", "2", ",", "8"}], "}"}], "}"}], 
    ",", "\"\<animation15.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678150116887226`*^9, 3.967815011690737*^9}, {
   3.967815425744852*^9, 3.967815428701359*^9}, 3.9678334646736727`*^9, {
   3.967876819671289*^9, 3.967876820031008*^9}, {3.967880035810792*^9, 
   3.967880066623735*^9}, 3.967915007415245*^9, {3.9679158184119167`*^9, 
   3.9679158841039467`*^9}, {3.96791593336574*^9, 3.96791595103228*^9}, {
   3.967916066078889*^9, 3.9679160821716537`*^9}, {3.96797987361471*^9, 
   3.967979878837438*^9}, 3.967980403846238*^9, {3.9679810004887457`*^9, 
   3.967981000865839*^9}, 
   3.970746166573658*^9},ExpressionUUID->"63917b59-f2bb-e04b-8d06-\
bf7075a4cf42"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 2, 8, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {354.26806640625, 365.73193359375}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 2}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> PolarPlot[
        Sin[$CellContext`n$$ $CellContext`\[Theta]], {$CellContext`\[Theta], 
         0, 2 Pi}, PlotRange -> {{-1.2, 1.2}, {-1.2, 1.2}}], 
      "Specifications" :> {{$CellContext`n$$, 2, 8}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {445.6089172363281, 457.0727844238281}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.9678334685918283`*^9, 3.9679158938322268`*^9, 
  3.9679159575240717`*^9, 3.967916082586948*^9, 3.96798146305732*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"77b3d290-25d6-45ff-84de-a3353146c021"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"30", ",", "6", ",", "False", ",", "\<\"orange\"\>", ",", "True", ",", 
   RowBox[{"-", "1.2`"}], ",", "1.2`", ",", 
   RowBox[{"-", "1.2`"}], ",", "1.2`", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.9678334685918283`*^9, 3.9679158938322268`*^9, 
  3.9679159575240717`*^9, 3.967916082586948*^9, 3.967981463088335*^9},
 CellLabel->
  "Out[112]=",ExpressionUUID->"b0e08cf1-23dd-4e5d-9dce-ea7762d3929f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.96798146428043*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"6a9e247d-322e-4ee3-8607-4a2ead686eb8"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.9679814642809258`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"ef7ff8e8-9a4d-4fee-a89e-78bf557908b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.967981464281538*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"473bb009-e8ca-4b65-a803-d0219c16f840"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.967981464281907*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"c3083ae6-cc93-4f6c-ae06-713853a95147"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.967981464282278*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"b9107fc4-3083-45af-a8fe-bd709a0932d8"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.9679814643451633`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"dd4625e8-2a69-47ad-8a53-82134ede24ba"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.9679814653504744`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"bfd3c450-04e2-48c4-b8e9-89ff2819b79a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation15/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation15/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.9679814653529253`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"fdc46f65-6002-40b4-8daa-2cb86af387c6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation15\"\>"}],
  SequenceForm["Archivo: ", "animation15"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.967981465354517*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"6b18586b-7d97-4197-95d6-9418c6f36c91"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.967981488554256*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"9da3c059-e040-4d78-95f7-e59bda1872d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation15/animation15.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation15/animation15.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967833468952408*^9, 3.967915895056587*^9, 
  3.9679159587304497`*^9, 3.967916083805807*^9, 3.96798148855512*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[111]:=",ExpressionUUID->"abfaa41f-d1f6-4b7b-bc22-eb4e937b04db"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation15/\
animation15.pdf\"\>"], "Output",
 CellChangeTimes->{3.9678334685918283`*^9, 3.9679158938322268`*^9, 
  3.9679159575240717`*^9, 3.967916082586948*^9, 3.967981488570683*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"616900a8-4518-42a1-ae21-58011c832813"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 16: caracola logar\[IAcute]tmica", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, {
   3.967814900911625*^9, 3.96781492829653*^9}, 3.9678150141444855`*^9, {
   3.9678800389811287`*^9, 3.967880059306746*^9}, {3.967916148945788*^9, 
   3.967916167817528*^9}},ExpressionUUID->"0827ab51-42ca-4a18-8ea3-\
ad0d9d46eda9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"a", "*", "\[Theta]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "25"}], ",", "25"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "25"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "25"}]}], ",", 
   RowBox[{"xmax", "=", "25"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "25"}]}], ",", 
   RowBox[{"ymax", "=", "25"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", 
      RowBox[{"PolarPlot", "[", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"a", "*", "\[Theta]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Theta]", ",", "0", ",", 
          RowBox[{"4", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0.1", ",", "0.5"}], "}"}], "}"}], 
    ",", "\"\<animation16.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9679161905363483`*^9, 3.9679162682702427`*^9}, {
   3.96791633559763*^9, 3.96791635026624*^9}, {3.96791643126823*^9, 
   3.967916449436715*^9}, {3.967979884580117*^9, 3.9679798888668947`*^9}, 
   3.967980408824985*^9, {3.9679810060545263`*^9, 3.967981006431961*^9}, 
   3.9707461719597187`*^9},ExpressionUUID->"0b60f958-d4ed-4ad3-b140-\
de55463d88a7"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = -3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], -3, 3, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {354.26806640625, 365.73193359375}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = -3}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> PolarPlot[
        Exp[$CellContext`a$$ $CellContext`\[Theta]], {$CellContext`\[Theta], 
         0, 4 Pi}, PlotRange -> {{-25, 25}, {-25, 25}}], 
      "Specifications" :> {{$CellContext`a$$, -3, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {445.6089172363281, 457.0727844238281}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967916271869959*^9, 3.967916465646141*^9, 
  3.967981506185854*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"5b623605-05fb-4b9e-94d2-101fd2a64b62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "8", ",", "False", ",", "\<\"green\"\>", ",", "True", ",", 
   RowBox[{"-", "25"}], ",", "25", ",", 
   RowBox[{"-", "25"}], ",", "25", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.967916271869959*^9, 3.967916465646141*^9, 
  3.9679815062149487`*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"1df29d1c-8489-4293-90c4-6b99f718766d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.967981506995091*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"0fbf6f98-e9b1-46b0-9a9c-bd1d661b3841"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.9679815069955883`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"e79f2698-2943-43cd-ba1f-89b85e4dc784"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.9679815069962*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"4fa37917-3143-4ba9-9efa-5c4f3f2d0643"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.9679815069965677`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"f00501b7-7ec4-417a-ab12-51eec17a61a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.967981506996935*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"04655ab0-c7c6-4955-88c5-a9368d0a253d"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.967981507076213*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"3119bdd5-bafd-486e-8932-a33eda65b954"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.967981508082082*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"9000e6e5-1f2e-4944-96c0-bdaea51609e2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation16/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation16/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.9679815080855837`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"8bc875b4-b3a8-4927-9808-f5912af3b93e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation16\"\>"}],
  SequenceForm["Archivo: ", "animation16"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.967981508088297*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"fea925e2-0750-41f8-baa7-d8b5d2eb48bc"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.967981525737566*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"10ba6fbf-f4d8-409f-8e63-6c14cdcf9862"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation16/animation16.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation16/animation16.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679162726812077`*^9, 3.9679164664476223`*^9, 
  3.9679815257384567`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[115]:=",ExpressionUUID->"ebf77eb5-27ce-4659-af6f-e374e082ed82"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation16/\
animation16.pdf\"\>"], "Output",
 CellChangeTimes->{3.967916271869959*^9, 3.967916465646141*^9, 
  3.967981525752249*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"c36c15ad-7b93-47cc-b4fe-bfc857b9c204"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 17: datos que evolucionan en el tiempo", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, 
   3.967814900911625*^9, {3.9678149317451916`*^9, 3.967814932210417*^9}, 
   3.9678150244209423`*^9, {3.967916518829823*^9, 
   3.967916526181068*^9}},ExpressionUUID->"796948fb-98b5-154f-a5b7-\
3183bd6bb814"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"i", "+", "phase"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "10", ",", "0.5"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"phase", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "40"}], ",", 
   RowBox[{"framesxSeg", "=", "10"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "0.5"}]}], ",", 
   RowBox[{"xmax", "=", "10"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "1.5"}]}], ",", 
   RowBox[{"ymax", "=", "1.5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "phase", "}"}], ",", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"i", "+", "phase"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "10", ",", "0.5"}], "}"}]}], "]"}], 
       "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"phase", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], "}"}], ",", "\"\<animation17.tex\>\"",
     ",", "frames", ",", "framesxSeg", ",", "grid", ",", "style", ",", "ejes",
     ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax", ",", "points"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678150308354034`*^9, 3.9678150308354034`*^9}, {
   3.9678154332435417`*^9, 3.9678154352579823`*^9}, {3.967876826916802*^9, 
   3.967876827483563*^9}, {3.967916522708262*^9, 3.967916541167424*^9}, {
   3.967916599903129*^9, 3.9679166565585423`*^9}, {3.967916790540944*^9, 
   3.967916802332717*^9}, {3.9679799090026703`*^9, 3.967979913771255*^9}, 
   3.9679804138546743`*^9, {3.967981012730589*^9, 3.967981013137801*^9}, 
   3.970746177373144*^9},ExpressionUUID->"73599b1d-5ca8-ad4c-90de-\
1bb65ce31008"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`phase$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`phase$$], 0, 2 Pi, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {217.70866138396673`, 229.17252857146673`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`phase$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> ListLinePlot[
        Table[{$CellContext`i, 
          Sin[$CellContext`i + $CellContext`phase$$]}, {$CellContext`i, 0, 10,
           0.5}], PlotRange -> {-1.5, 1.5}], 
      "Specifications" :> {{$CellContext`phase$$, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {309.04951221404485`, 320.51337940154485`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967916812773678*^9, 3.967981551599889*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"989461ab-1ac7-4954-b7b0-2c693620a1ae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", "10", ",", "True", ",", "\<\"green\"\>", ",", "True", ",", 
   RowBox[{"-", "0.5`"}], ",", "10", ",", 
   RowBox[{"-", "1.5`"}], ",", "1.5`", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.967916812773678*^9, 3.96798155162932*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"f718e34f-2d96-4a7a-a696-f832db25e217"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981551869959*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"df359fb0-9e61-451b-b57f-3c39cc5f7900"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981551870463*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"a13b6d6b-7f1d-4b42-a665-75db4cad25b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981551871118*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"c1ab11d8-ecdc-4ef4-b084-e288ef01b5b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981551871484*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"50a69e54-1584-4bb0-991b-f7398e2f1ae5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981551871851*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"33c4d6c7-0acd-4a1a-82e6-e05bd7dc044d"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981551939879*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"6ffb9a6c-e0bb-470a-9663-d408f3d35f5e"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981552946249*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"c9a2e1df-2b8f-4a8b-ab1f-29c1556a5922"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation17/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation17/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981552949882*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"c639ab08-bed3-465b-8bc1-56be2df3e6ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation17\"\>"}],
  SequenceForm["Archivo: ", "animation17"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981552952382*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"a88e4a18-d1ba-4cef-be1f-9e4014685609"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.967981554947688*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"61fa771d-1184-4c33-90b6-5b17e487910c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation17/animation17.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation17/animation17.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9679168130439053`*^9, 3.9679815549484262`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[119]:=",ExpressionUUID->"0c22fb97-fe65-4b3c-a5b3-c7f7c45724f9"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation17/\
animation17.pdf\"\>"], "Output",
 CellChangeTimes->{3.967916812773678*^9, 3.967981554962225*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"36d8d207-282b-4d28-ba2c-74d72dddca95"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 18: puntos conectados (la genera pero sin puntos)", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, 
   3.967814900911625*^9, {3.9678149398011*^9, 3.9678149401954803`*^9}, {
   3.9678150715814095`*^9, 3.9678150719579716`*^9}, {3.967917303781375*^9, 
   3.967917310951038*^9}, {3.967917573761496*^9, 
   3.967917580798761*^9}},ExpressionUUID->"0e0f1352-33a7-2d43-a0e0-\
4f4a8a625eb1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"amp", "*", 
          RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "6", ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.3"}], ",", "2.3"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"amp", ",", "0.5", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "25"}], ",", 
   RowBox[{"framesxSeg", "=", "8"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "0.5"}]}], ",", 
   RowBox[{"xmax", "=", "6"}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "2.3"}]}], ",", 
   RowBox[{"ymax", "=", "2.3"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "amp", "}"}], ",", 
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"amp", "*", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "6", ",", "0.2"}], "}"}]}], "]"}], ",", 
        RowBox[{"Joined", "->", "True"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"amp", ",", "0.5", ",", "2"}], "}"}], "}"}], 
    ",", "\"\<animation18.tex\>\"", ",", "frames", ",", "framesxSeg", ",", 
    "grid", ",", "style", ",", "ejes", ",", "xmin", ",", "xmax", ",", "ymin", 
    ",", "ymax", ",", "points"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967815069559187*^9, 3.967815069559187*^9}, {
   3.967815448709194*^9, 3.9678154503888664`*^9}, {3.967876838884848*^9, 
   3.9678768392910767`*^9}, {3.967917307114278*^9, 3.967917362511264*^9}, {
   3.9679173943756227`*^9, 3.9679174124610243`*^9}, {3.9679174982113857`*^9, 
   3.967917522718896*^9}, {3.967977875947516*^9, 3.9679778763508177`*^9}, {
   3.9679782582928534`*^9, 3.9679782587040586`*^9}, {3.967978292236644*^9, 
   3.967978320064557*^9}, {3.967979919005495*^9, 3.967979923941893*^9}, 
   3.967980417690878*^9, {3.967981019167609*^9, 3.9679810195287857`*^9}, 
   3.970746185173531*^9},ExpressionUUID->"4e293b0a-1820-5c41-a2d6-\
6c0042da2ec8"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`amp$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`amp$$], 0.5, 2, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {212.79628321903135`, 224.26015040653135`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`amp$$ = 0.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> ListPlot[
        Table[{$CellContext`x, $CellContext`amp$$ 
          Sin[$CellContext`x]}, {$CellContext`x, 0, 6, 0.2}], 
        PlotRange -> {-2.3, 2.3}], 
      "Specifications" :> {{$CellContext`amp$$, 0.5, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {304.1371340491095, 315.6010012366095}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.967917533738143*^9, 3.967977595139954*^9, {3.967977876987597*^9, 
   3.967977904838582*^9}, 3.967978081523271*^9, 3.9679782030197*^9, 
   3.967978261656952*^9, {3.967981580355404*^9, 3.967981618988649*^9}},
 CellLabel->
  "Out[131]=",ExpressionUUID->"5ee138a4-ebe4-4dfb-86ff-0fb51d62580a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "8", ",", "False", ",", "\<\"orange\"\>", ",", "True", ",", 
   RowBox[{"-", "0.5`"}], ",", "6", ",", 
   RowBox[{"-", "2.3`"}], ",", "2.3`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.967917533738143*^9, 3.967977595139954*^9, {3.967977876987597*^9, 
   3.967977904838582*^9}, 3.967978081523271*^9, 3.9679782030197*^9, 
   3.967978261656952*^9, {3.967981580355404*^9, 3.967981619016553*^9}},
 CellLabel->
  "Out[132]=",ExpressionUUID->"a54879a2-8b04-4b77-bc5b-dbd419234c52"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.967981619169182*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"6b00fceb-0b83-4155-9275-f6bcf3770e2b"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.9679816191696978`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"3fffc3de-4c50-439a-8b89-9db14c97ef69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.9679816191703463`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"ec7f9347-2f94-4600-b4ff-455d79629912"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.9679816191707172`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"55eb5783-c3e1-4c09-88c9-2ef4d7c2c58a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.967981619171082*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"f5567689-f8b1-421a-92f5-51542ac76573"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.967981619237678*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"6fbef2be-39e1-4612-969d-c7aa6a1a1d46"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.96798162024442*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"09e82418-7dc5-4dac-b3a3-8383ddd14b88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation18/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation18/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.967981620247326*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"13aa9bd6-8e22-44db-b71a-f4160403e396"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation18\"\>"}],
  SequenceForm["Archivo: ", "animation18"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.967981620249662*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"be32dcca-4412-4e33-84e4-c5bbd902064b"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.967981622027156*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"400c6954-fc46-41eb-a128-ad34b0da577b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation18/animation18.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation18/animation18.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967917533931691*^9, 3.967977595325976*^9, {3.967977877172659*^9, 
   3.967977905027006*^9}, 3.967978081709091*^9, 3.967978203208777*^9, 
   3.9679782618572817`*^9, {3.96798158053889*^9, 3.9679816220277987`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[131]:=",ExpressionUUID->"0dacaeb7-a8dc-4da8-a6c1-aa2692e1eeb9"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation18/\
animation18.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967917533738143*^9, 3.967977595139954*^9, {3.967977876987597*^9, 
   3.967977904838582*^9}, 3.967978081523271*^9, 3.9679782030197*^9, 
   3.967978261656952*^9, {3.967981580355404*^9, 3.9679816220413094`*^9}},
 CellLabel->
  "Out[134]=",ExpressionUUID->"76860c4b-41fc-4f06-badf-59672b225d71"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 19: combinar Plot y ParametricPlot", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, 
   3.967814900911625*^9, {3.9678149469864864`*^9, 3.9678149479037437`*^9}, {
   3.967815108602951*^9, 3.9678151091567764`*^9}, {3.9679180057948713`*^9, 
   3.967918012441998*^9}},ExpressionUUID->"f1e1f7b4-6347-3642-8b51-\
66409ae18429"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "a"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", " ", "t"}], ",", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "25"}], ",", 
   RowBox[{"framesxSeg", "=", "10"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "0.5"}]}], ",", 
   RowBox[{"xmax", "=", 
    RowBox[{"2", "\[Pi]"}]}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "5"}]}], ",", 
   RowBox[{"ymax", "=", "5"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"x", " ", "a"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "5"}], ",", "5"}], "}"}]}]}], "]"}], ",", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a", " ", "t"}], ",", 
            RowBox[{"a", " ", 
             RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], "}"}], ",", "\"\<animation19.tex\>\"",
     ",", "frames", ",", "framesxSeg", ",", "grid", ",", "style", ",", "ejes",
     ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax", ",", "points"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9678151065977383`*^9, 3.9678151065994854`*^9}, {
   3.9678154687083015`*^9, 3.967815470853857*^9}, {3.967876852404272*^9, 
   3.9678768527919207`*^9}, {3.967918009431943*^9, 3.967918022658615*^9}, {
   3.967918242922542*^9, 3.9679182792044907`*^9}, {3.96791835022571*^9, 
   3.967918378973991*^9}, {3.967979931150922*^9, 3.9679799367101803`*^9}, 
   3.967980431854836*^9, {3.9679810251060257`*^9, 3.967981025481142*^9}, 
   3.970746191283785*^9},ExpressionUUID->"ec25f39e-6c0f-6242-83c1-\
cdcc9f61ea90"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 2 Pi, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {212.79628321903138`, 224.26015040653138`}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Show[
        Plot[
         Sin[$CellContext`x $CellContext`a$$], {$CellContext`x, 0, 2 Pi}, 
         PlotRange -> {-5, 5}], 
        ParametricPlot[{$CellContext`a$$ $CellContext`t, $CellContext`a$$ 
          Sin[$CellContext`t]}, {$CellContext`t, 0, 2 Pi}]], 
      "Specifications" :> {{$CellContext`a$$, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {304.1371340491095, 315.6010012366095}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967918289986772*^9, 3.967918351426173*^9, 
  3.9679183929783907`*^9, 3.967981640814728*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"0b955fe3-35ff-4d4e-8233-b69dffc69935"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "10", ",", "True", ",", "\<\"green\"\>", ",", "True", ",", 
   RowBox[{"-", "0.5`"}], ",", 
   RowBox[{"2", " ", "\[Pi]"}], ",", 
   RowBox[{"-", "5"}], ",", "5", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.967918289986772*^9, 3.967918351426173*^9, 
  3.9679183929783907`*^9, 3.967981640850663*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"3b810996-40c4-49c1-834b-485c62be07dc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981641600679*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"6e00380b-ca74-4f2c-9a25-628306eb1c2c"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.9679816416011963`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"d3afea3a-aace-4885-9f40-293898647eb2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981641601841*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"0ae354d5-d1db-4b53-88e9-ddaa4ae34e34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981641602208*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"efdd41c5-d064-420b-9b86-7274c8f38a04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981641602583*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"c813b1e3-99ea-40ba-9982-d9e4ad5b6e77"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981641672749*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"a403f14a-d18e-41d1-aeee-0e17d59d8802"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981642677743*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"460f9c9f-6f5c-48ea-8760-c6a8084458e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation19/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation19/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.9679816426799297`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"420c1c76-4cc0-4891-b777-8f028e8907a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation19\"\>"}],
  SequenceForm["Archivo: ", "animation19"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981642682035*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"f71a99ff-62ff-4f73-bd2f-3d6213780e1e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.9679816601765547`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"7a86f73a-67b8-4a42-99fa-2403af1d3b09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation19/animation19.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation19/animation19.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918290216331*^9, 3.967918351632085*^9, 
  3.9679183937600737`*^9, 3.967981660177272*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[135]:=",ExpressionUUID->"ffcbabf1-fb5e-4813-827e-39340df6a240"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation19/\
animation19.pdf\"\>"], "Output",
 CellChangeTimes->{3.967918289986772*^9, 3.967918351426173*^9, 
  3.9679183929783907`*^9, 3.967981660191313*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"304e0a2b-eafb-4137-833a-3ebde6bcdb8e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 20: otras combinaciones", "Subsection",
 CellChangeTimes->{{3.9678128487468014`*^9, 3.96781287770467*^9}, {
   3.967813911937727*^9, 3.967813912466299*^9}, {3.9678139931214085`*^9, 
   3.967814002142147*^9}, {3.967814318927353*^9, 3.9678143190884724`*^9}, 
   3.967814900911625*^9, {3.9678149469864864`*^9, 3.9678149479037437`*^9}, {
   3.967815108602951*^9, 3.9678151091567764`*^9}, {3.9679180057948713`*^9, 
   3.967918012441998*^9}, {3.9679184385500603`*^9, 3.967918438761918*^9}, {
   3.967918937568987*^9, 
   3.9679189405676613`*^9}},ExpressionUUID->"684ea65d-51eb-4522-b2f9-\
96b8c6a91943"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"Cos", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{
             RowBox[{"2", "\[Pi]"}], "+", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"s", "-", 
          RowBox[{"Sin", "[", "s", "]"}]}], ",", 
         RowBox[{"1", "-", 
          RowBox[{"Cos", "[", "s", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "t"}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"PolarPlot", "[", 
      RowBox[{
       RowBox[{"0.3", "*", "\[Theta]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", "t"}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "s"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
     
     RowBox[{"PlotRange", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{
           RowBox[{"2", "\[Pi]"}], "+", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.1", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"frames", "=", "50"}], ",", 
   RowBox[{"framesxSeg", "=", "12"}], ",", 
   RowBox[{"grid", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}], ",", 
   RowBox[{"style", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<red\>\"", ",", " ", "\"\<blue\>\"", ",", 
       " ", "\"\<green\>\"", ",", " ", "\"\<orange\>\"", ",", 
       " ", "\"\<purple\>\"", ",", " ", "\"\<black\>\""}], "}"}], "]"}]}], ",", 
   RowBox[{"ejes", "=", "True"}], ",", 
   RowBox[{"xmin", "=", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"xmax", "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]"}], "+", "1"}]}], ",", 
   RowBox[{"ymin", "=", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{"ymax", "=", "3"}], ",", 
   RowBox[{"points", "=", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CreateTikZAnimation", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"Cos", "[", "x", "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{"Blue", ",", "Thick"}], "}"}]}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{
                RowBox[{"2", "\[Pi]"}], "+", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"s", "-", 
             RowBox[{"Sin", "[", "s", "]"}]}], ",", 
            RowBox[{"1", "-", 
             RowBox[{"Cos", "[", "s", "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "t"}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
        RowBox[{"PolarPlot", "[", 
         RowBox[{
          RowBox[{"0.3", "*", "\[Theta]"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Theta]", ",", "0", ",", "t"}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{"Green", ",", "Thick"}], "}"}]}]}], "]"}], ",", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"t", ",", "s"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"s", ",", 
              RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", 
            RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{"Gray", ",", "Dashed", ",", "Thin"}], "}"}]}]}], "]"}], ",", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{
              RowBox[{"2", "\[Pi]"}], "+", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.1", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], "}"}], ",", "\"\<animation20.tex\>\"",
     ",", "frames", ",", "framesxSeg", ",", "grid", ",", "style", ",", "ejes",
     ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax", ",", "points"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96791858791333*^9, 3.9679185879147*^9}, {
   3.9679187973112183`*^9, 3.9679187977024527`*^9}, {3.9679188465023527`*^9, 
   3.96791884707513*^9}, {3.9679189478487673`*^9, 3.9679190006790113`*^9}, {
   3.967919031888098*^9, 3.9679190430581493`*^9}, {3.967919078523985*^9, 
   3.967919148257951*^9}, {3.96797994521736*^9, 3.967979950738534*^9}, 
   3.967980437241832*^9, {3.9679810320067244`*^9, 3.967981032388592*^9}, 
   3.970746201216668*^9},ExpressionUUID->"84ad1fe5-e1c6-4225-9256-\
9c76a02acd42"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0.1, 2 Pi, ControlType -> Manipulator}}, 
    Typeset`size$$ = {720., {227.5051263730873, 238.9689935605873}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0.1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> Show[
        Plot[
        2 Cos[$CellContext`x], {$CellContext`x, 0, 2 Pi}, 
         PlotStyle -> {Blue, Thick}, PlotRange -> {{-1, 2 Pi + 1}, {-3, 3}}], 
        
        ParametricPlot[{$CellContext`s - Sin[$CellContext`s], 1 - 
          Cos[$CellContext`s]}, {$CellContext`s, 0, $CellContext`t$$}, 
         PlotStyle -> {Red, Thick}], 
        PolarPlot[
        0.3 $CellContext`\[Theta], {$CellContext`\[Theta], 
          0, $CellContext`t$$}, PlotStyle -> {Green, Thick}], 
        ParametricPlot[{{$CellContext`t$$, $CellContext`s}, {$CellContext`s, 
           Sin[$CellContext`t$$]}}, {$CellContext`s, -2, 2}, 
         PlotStyle -> {Gray, Dashed, Thin}], 
        PlotRange -> {{-1, 2 Pi + 1}, {-3, 3}}], 
      "Specifications" :> {{$CellContext`t$$, 0.1, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{810.2, {318.84597720316543`, 330.30984439066543`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.967918605552459*^9, 3.96791885104002*^9, 
  3.96791916041014*^9, 3.9679816869507217`*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"e98d64b5-60f3-4bdd-8f81-197f33ef1efe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"50", ",", "12", ",", "True", ",", "\<\"black\"\>", ",", "True", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "\[Pi]"}]}], ",", 
   RowBox[{"-", "3"}], ",", "3", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.967918605552459*^9, 3.96791885104002*^9, 
  3.96791916041014*^9, 3.967981687011242*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"d83e9ebd-6780-464f-91cb-c8f31f780fe9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981689320149*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"42099912-d998-452c-8fe7-44fbe43bc2c6"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981689320683*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"84410568-f5b8-487d-8993-69afb46b034e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981689321357*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"7be9a1a9-de22-454b-aa5b-404c21157afe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981689321753*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"00ca63bc-1faa-48d0-9e5e-bf5432b305ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981689322143*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"006dfab3-983e-45d3-b733-7377a80bcc50"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981689390492*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"72f71e39-748a-4151-a777-64d4da45edce"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.9679816903966846`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"399cc6a6-2cd6-4c6e-ac20-f15dcc3e1aa1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation20/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/animation20/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981690401414*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"9389468d-8b1e-4c52-bea0-e2eb620252da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"animation20\"\>"}],
  SequenceForm["Archivo: ", "animation20"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981690404089*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"9c401af6-d083-4bdf-af78-529d139b8d38"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.96798172913719*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"7226a89e-1cc5-4332-b18e-5e97a469bc32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/animation20/animation20.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/animation20/animation20.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967918851040975*^9, 3.967919162839867*^9, 
  3.967981729138123*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[139]:=",ExpressionUUID->"bd661f0b-095a-485a-a58e-1d56202b4887"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/animation20/\
animation20.pdf\"\>"], "Output",
 CellChangeTimes->{3.967918605552459*^9, 3.96791885104002*^9, 
  3.96791916041014*^9, 3.967981729150819*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"8c054090-d749-4622-a023-a80df81cb328"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1569, 763},
WindowMargins->{{-5, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5420f22d-720b-4572-84cb-8f050efca9fa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 197, 3, 58, "Input",ExpressionUUID->"8649fc87-1c15-4bf9-9237-6c8c3a8bdb46"],
Cell[CellGroupData[{
Cell[798, 29, 1025, 30, 86, "Print",ExpressionUUID->"1c7ac391-3e80-48fb-a7a1-756196bac0d3"],
Cell[1826, 61, 251, 4, 46, "Print",ExpressionUUID->"ff26a3ca-986d-4a3c-a8a5-a53b77f763d4"],
Cell[2080, 67, 248, 4, 46, "Print",ExpressionUUID->"9c2cf494-86dd-4526-b340-92d81792d6ac"],
Cell[2331, 73, 494, 10, 46, "Print",ExpressionUUID->"5febd24b-9091-4e35-8984-e0f588f6f5dd"],
Cell[2828, 85, 529, 11, 46, "Print",ExpressionUUID->"8b4bb031-4b0a-4456-bc5e-6f1fee87e2e6"],
Cell[3360, 98, 498, 10, 46, "Print",ExpressionUUID->"0abcff7a-7d3b-4562-8ed3-991039b186a4"],
Cell[3861, 110, 492, 10, 46, "Print",ExpressionUUID->"cc12b55c-9db7-429a-ab35-c1219d0b24ba"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4402, 126, 537, 8, 136, "Subtitle",ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],
Cell[CellGroupData[{
Cell[4964, 138, 236, 4, 58, "Input",ExpressionUUID->"b56a2495-e5bc-de40-81a5-bea435140357"],
Cell[5203, 144, 80009, 1615, 1765, "Output",ExpressionUUID->"8c917844-1ce4-4a7d-a8b8-172a67955eb6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85249, 1764, 182, 3, 106, "Subsection",ExpressionUUID->"e23d2182-e714-5f48-ab0a-f012380117ba"],
Cell[CellGroupData[{
Cell[85456, 1771, 2799, 66, 524, "Input",ExpressionUUID->"236b5b4a-930a-6d44-b4c0-0a6228af7ad0"],
Cell[88258, 1839, 2079, 38, 643, "Output",ExpressionUUID->"213024be-a7a7-4b31-aafa-e40934ab248e"],
Cell[90340, 1879, 567, 10, 66, "Output",ExpressionUUID->"a0fd58a2-28fc-40af-b419-72ad52371269"],
Cell[CellGroupData[{
Cell[90932, 1893, 614, 12, 46, "Print",ExpressionUUID->"ee6cf728-11d5-42e7-8e59-4257deae8800"],
Cell[91549, 1907, 405, 7, 46, "Print",ExpressionUUID->"81e0a02f-7cca-409f-ba4f-0487c837c808"],
Cell[91957, 1916, 597, 12, 46, "Print",ExpressionUUID->"a3a28c9e-8786-48cd-b11a-5aaf2922aa13"],
Cell[92557, 1930, 624, 12, 46, "Print",ExpressionUUID->"c11d7457-bcfa-43e2-aede-b27e300e78c2"],
Cell[93184, 1944, 606, 13, 46, "Print",ExpressionUUID->"3fe9d1a5-7e2a-449b-834d-f5e89a77bd03"],
Cell[93793, 1959, 413, 7, 46, "Print",ExpressionUUID->"8bd6428e-b043-4718-9a19-087f52a36df9"],
Cell[94209, 1968, 416, 7, 46, "Print",ExpressionUUID->"6eb73eed-fe04-4a72-b5e0-737d4768b5f5"],
Cell[94628, 1977, 656, 15, 46, "Print",ExpressionUUID->"bfa0ecc6-8487-4314-87f5-a254be987555"],
Cell[95287, 1994, 533, 11, 46, "Print",ExpressionUUID->"9872c47e-62f6-4bba-aef1-94244c717253"],
Cell[95823, 2007, 412, 7, 46, "Print",ExpressionUUID->"7446248a-07d1-4cb4-812d-d7494c0e63b5"],
Cell[96238, 2016, 664, 15, 46, "Print",ExpressionUUID->"7de2c57a-c744-4acb-8aa4-0ba210a2bf52"]
}, Open  ]],
Cell[96917, 2034, 461, 6, 66, "Output",ExpressionUUID->"0c3a8394-36e9-4d9b-8429-321e2af52e54"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97427, 2046, 292, 4, 106, "Subsection",ExpressionUUID->"a30762b1-6539-5143-a0b1-040519a02298"],
Cell[CellGroupData[{
Cell[97744, 2054, 3085, 73, 565, "Input",ExpressionUUID->"c56723d5-b545-b44a-b534-92cd0b6399d2"],
Cell[100832, 2129, 1968, 37, 653, "Output",ExpressionUUID->"4465c8da-1a81-4500-b91c-7414e54bd0b5"],
Cell[102803, 2168, 424, 8, 66, "Output",ExpressionUUID->"213837bd-ae9a-444b-b4e5-915fb40f2466"],
Cell[CellGroupData[{
Cell[103252, 2180, 515, 10, 46, "Print",ExpressionUUID->"2b2e393a-46ea-469c-91b0-ac05d14dcea1"],
Cell[103770, 2192, 306, 5, 46, "Print",ExpressionUUID->"ff79b2cb-d3c6-45b7-b5bc-6f6547a97eac"],
Cell[104079, 2199, 498, 10, 46, "Print",ExpressionUUID->"0504124b-7395-4959-9cf1-02e31fbded93"],
Cell[104580, 2211, 525, 10, 46, "Print",ExpressionUUID->"67db3bcc-3724-4055-8cb4-b0bf3a4e7a17"],
Cell[105108, 2223, 505, 11, 46, "Print",ExpressionUUID->"6f3af497-6819-485f-b458-c4a40dad4315"],
Cell[105616, 2236, 314, 5, 46, "Print",ExpressionUUID->"6bee39cd-d82a-4a38-b7b9-5bb88560122d"],
Cell[105933, 2243, 315, 5, 46, "Print",ExpressionUUID->"24816fec-b033-4239-9bbe-fa81739f87ff"],
Cell[106251, 2250, 555, 13, 46, "Print",ExpressionUUID->"42095ebe-4a9f-4b26-a865-9806444cf83e"],
Cell[106809, 2265, 434, 9, 46, "Print",ExpressionUUID->"3fc0b8b8-4150-44a7-9c43-e74adbc7522e"],
Cell[107246, 2276, 315, 5, 46, "Print",ExpressionUUID->"f8b27419-4a78-4583-b183-2ab7a6a84a7c"],
Cell[107564, 2283, 565, 13, 46, "Print",ExpressionUUID->"f2dfc0fb-8908-4ea9-b42e-abedc68dad87"]
}, Open  ]],
Cell[108144, 2299, 318, 4, 66, "Output",ExpressionUUID->"8e28cae4-f847-4628-9a26-cbe647009d5e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108511, 2309, 384, 6, 106, "Subsection",ExpressionUUID->"7356247a-cfc8-ec4d-b06c-664651297cc5"],
Cell[CellGroupData[{
Cell[108920, 2319, 3357, 83, 524, "Input",ExpressionUUID->"83d32608-ba28-fd4a-8a53-1d9a3168048a"],
Cell[112280, 2404, 1984, 38, 683, "Output",ExpressionUUID->"385cbc9e-a2c3-4b02-941d-a5f8d7a73f0f"],
Cell[114267, 2444, 460, 8, 66, "Output",ExpressionUUID->"9eb23df2-d2fc-4962-b18f-fd3a1b79ed7c"],
Cell[CellGroupData[{
Cell[114752, 2456, 547, 11, 46, "Print",ExpressionUUID->"5eba342a-01e9-4c5f-98d5-6dee5ed4c4a5"],
Cell[115302, 2469, 338, 6, 46, "Print",ExpressionUUID->"1eec280f-fb6e-4f50-ae61-be65c1b717b9"],
Cell[115643, 2477, 530, 11, 46, "Print",ExpressionUUID->"c05f6260-9d42-4510-b139-5fb70e740b4e"],
Cell[116176, 2490, 559, 11, 46, "Print",ExpressionUUID->"2076e2fe-ac07-47a4-926c-6e5e3e5adeba"],
Cell[116738, 2503, 539, 12, 46, "Print",ExpressionUUID->"5f884a56-de3f-434c-9636-6f2f556c2c36"],
Cell[117280, 2517, 348, 6, 46, "Print",ExpressionUUID->"5f6f15f1-043a-4ef0-bcf1-21d1ac82148b"],
Cell[117631, 2525, 347, 6, 46, "Print",ExpressionUUID->"22ef540f-d1a3-4431-8fd2-bb6c90082edf"],
Cell[117981, 2533, 587, 14, 46, "Print",ExpressionUUID->"35546ba6-29bb-4233-8b9c-66989dbfa292"],
Cell[118571, 2549, 466, 10, 46, "Print",ExpressionUUID->"a01844d3-070a-4566-bb0c-6ff792378e0c"],
Cell[119040, 2561, 345, 6, 46, "Print",ExpressionUUID->"c5682f00-d76d-4a3d-a196-40400ecd0d17"],
Cell[119388, 2569, 597, 14, 46, "Print",ExpressionUUID->"42c8bb4c-eaf1-4372-b4ab-16566fcb4b90"]
}, Open  ]],
Cell[120000, 2586, 342, 5, 66, "Output",ExpressionUUID->"51cc3dde-2deb-4e21-8d7d-552b9211ab5f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[120391, 2597, 357, 5, 106, "Subsection",ExpressionUUID->"401ee21d-f3bf-244a-9df9-a65d1aba2388"],
Cell[CellGroupData[{
Cell[120773, 2606, 3600, 87, 494, "Input",ExpressionUUID->"cf374627-f179-474b-98a5-f6c08046f5ec"],
Cell[124376, 2695, 2102, 40, 683, "Output",ExpressionUUID->"fc278b96-ab22-473d-9ef3-a754ffab8290"],
Cell[126481, 2737, 536, 9, 66, "Output",ExpressionUUID->"4bf1bc5e-b17a-47b6-b02e-f4f661f2f67e"],
Cell[CellGroupData[{
Cell[127042, 2750, 616, 12, 46, "Print",ExpressionUUID->"da0e2357-2f59-4da5-917d-6b0e069ff1b7"],
Cell[127661, 2764, 409, 7, 46, "Print",ExpressionUUID->"6bb137f6-7cbf-45e0-a58e-bf342cb736d2"],
Cell[128073, 2773, 599, 12, 46, "Print",ExpressionUUID->"883b0e57-3035-43a3-a671-5ffcc374e0c9"],
Cell[128675, 2787, 626, 12, 46, "Print",ExpressionUUID->"7a5f4733-ead8-4ea7-bce8-25ca95329034"],
Cell[129304, 2801, 606, 13, 46, "Print",ExpressionUUID->"0acfc98f-3bf8-414d-91c7-1d975b32ea7f"],
Cell[129913, 2816, 417, 7, 46, "Print",ExpressionUUID->"b052e9ba-320d-4ba6-b489-146d48217530"],
Cell[130333, 2825, 418, 7, 46, "Print",ExpressionUUID->"16fc118f-905c-45e8-8dd4-a6302af6d719"],
Cell[130754, 2834, 658, 15, 46, "Print",ExpressionUUID->"89dad0a5-db65-4466-a4ea-c3edf93faecf"],
Cell[131415, 2851, 537, 11, 46, "Print",ExpressionUUID->"8ded3fe4-2ddb-47c6-b2f7-44fb69af84ca"],
Cell[131955, 2864, 414, 7, 46, "Print",ExpressionUUID->"4cf087b9-e909-4eb7-85e6-ae0a128b838f"],
Cell[132372, 2873, 666, 15, 46, "Print",ExpressionUUID->"d10b3484-ceac-4301-8549-dece5884ad33"]
}, Open  ]],
Cell[133053, 2891, 419, 6, 66, "Output",ExpressionUUID->"76032890-dcca-45f8-b274-1ec91b58042a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133521, 2903, 409, 6, 106, "Subsection",ExpressionUUID->"d12a79f1-0cde-a640-9bca-d317b1c56135"],
Cell[CellGroupData[{
Cell[133955, 2913, 3721, 93, 535, "Input",ExpressionUUID->"ed3dc65a-a562-174c-923e-7e7a8e35972e"],
Cell[137679, 3008, 2036, 39, 672, "Output",ExpressionUUID->"46ed071a-76d5-48ae-8bd5-f8f7e44a8782"],
Cell[139718, 3049, 455, 8, 66, "Output",ExpressionUUID->"0d8e0cbf-a357-456a-bce3-365c55c990ea"],
Cell[CellGroupData[{
Cell[140198, 3061, 537, 11, 46, "Print",ExpressionUUID->"c94a2f6f-87a7-4145-9fff-1aa54e0e7007"],
Cell[140738, 3074, 328, 6, 46, "Print",ExpressionUUID->"0f69c2a0-b270-48a2-9b82-e5d3882ded57"],
Cell[141069, 3082, 520, 11, 46, "Print",ExpressionUUID->"c2be54b3-3dc7-41f5-91db-6d6fbb59215f"],
Cell[141592, 3095, 547, 11, 46, "Print",ExpressionUUID->"4220abfc-0112-4184-b2c2-6462339ab874"],
Cell[142142, 3108, 526, 12, 46, "Print",ExpressionUUID->"cf81e7e0-1d1a-4e40-bddd-21617bc67791"],
Cell[142671, 3122, 336, 6, 46, "Print",ExpressionUUID->"a2ce6661-290e-454e-bd01-9a98d2174f45"],
Cell[143010, 3130, 337, 6, 46, "Print",ExpressionUUID->"f4777feb-b67d-44aa-bcc0-f55ac2128cac"],
Cell[143350, 3138, 576, 14, 46, "Print",ExpressionUUID->"f2f0aed1-d1ad-4bf1-8a12-4146b41a08bf"],
Cell[143929, 3154, 458, 10, 46, "Print",ExpressionUUID->"39545b03-0928-4f51-9399-7459bdd4b685"],
Cell[144390, 3166, 334, 6, 46, "Print",ExpressionUUID->"5ffd4232-b3f6-48be-8f77-9f8e1d81a3a4"],
Cell[144727, 3174, 587, 14, 46, "Print",ExpressionUUID->"f30db64c-ef5f-4978-bc81-cc7de72aab8a"]
}, Open  ]],
Cell[145329, 3191, 338, 5, 66, "Output",ExpressionUUID->"f3c14aa2-84a7-4a0e-9d9d-b6538510939f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[145716, 3202, 394, 6, 106, "Subsection",ExpressionUUID->"73e8f9a8-2746-cf40-baf9-aeafc07aabe8"],
Cell[CellGroupData[{
Cell[146135, 3212, 3470, 84, 606, "Input",ExpressionUUID->"c53fa6f5-3839-b84b-9518-e924d7057c45"],
Cell[149608, 3298, 1986, 38, 864, "Output",ExpressionUUID->"d65202ae-ffea-4a2e-84c4-45ca22a23843"],
Cell[151597, 3338, 417, 7, 66, "Output",ExpressionUUID->"d6264221-ad35-4070-a8f5-e5eb7f4869f0"],
Cell[CellGroupData[{
Cell[152039, 3349, 493, 10, 46, "Print",ExpressionUUID->"e59e17d2-8d55-46c2-ac33-efd50c5d27df"],
Cell[152535, 3361, 281, 5, 46, "Print",ExpressionUUID->"1ed70ab0-bacb-42e8-ac77-fa7ee34fc500"],
Cell[152819, 3368, 473, 10, 46, "Print",ExpressionUUID->"74face42-5df9-46f7-aa65-b1a17751ba54"],
Cell[153295, 3380, 503, 10, 46, "Print",ExpressionUUID->"2271242a-0f34-4733-bd74-536d6ea2e746"],
Cell[153801, 3392, 483, 11, 46, "Print",ExpressionUUID->"20c8fb9e-0f60-4d48-8819-83a9175e8452"],
Cell[154287, 3405, 290, 5, 46, "Print",ExpressionUUID->"78f08df9-c201-4ef2-a161-e49500dbcaed"],
Cell[154580, 3412, 293, 5, 46, "Print",ExpressionUUID->"4e36c052-f53c-4b95-a83e-c54760946b5f"],
Cell[154876, 3419, 531, 13, 46, "Print",ExpressionUUID->"988a1bd8-6860-4ae7-bfd4-b0b6dc7b6cfb"],
Cell[155410, 3434, 410, 9, 46, "Print",ExpressionUUID->"352099f4-83dc-48e6-bc1c-ef155429cf3b"],
Cell[155823, 3445, 289, 5, 46, "Print",ExpressionUUID->"595b6032-fad1-45b6-ae96-63e1b2b70bfc"],
Cell[156115, 3452, 541, 13, 46, "Print",ExpressionUUID->"4d2b35d1-0b65-4da7-bb69-fb8aa27a7ee6"]
}, Open  ]],
Cell[156671, 3468, 291, 4, 66, "Output",ExpressionUUID->"5f3a47c2-39ca-4a39-b8f9-a05181de4ce9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[157011, 3478, 388, 6, 106, "Subsection",ExpressionUUID->"bb14fcf3-836c-6943-9006-c04d5b60962e"],
Cell[CellGroupData[{
Cell[157424, 3488, 3462, 83, 576, "Input",ExpressionUUID->"29e52fed-f6d5-4e49-aa80-0e1f1644af86"],
Cell[160889, 3573, 2004, 38, 885, "Output",ExpressionUUID->"c8a90d1c-438b-4a5f-ac7b-0073f6cd03d2"],
Cell[162896, 3613, 426, 7, 66, "Output",ExpressionUUID->"2a7db521-691d-4d99-b7b3-ff9e0a9aecc9"],
Cell[CellGroupData[{
Cell[163347, 3624, 514, 10, 46, "Print",ExpressionUUID->"0c379fac-a588-41e1-bf2a-cc12ab41f29f"],
Cell[163864, 3636, 306, 5, 46, "Print",ExpressionUUID->"91d22a41-fea9-469d-8444-5f8809287052"],
Cell[164173, 3643, 498, 10, 46, "Print",ExpressionUUID->"f3b2bbf0-cfc1-4b0b-94bb-0ae71796b877"],
Cell[164674, 3655, 524, 10, 46, "Print",ExpressionUUID->"5ccc30c2-6d1a-4652-9f50-64f8d2e80fa4"],
Cell[165201, 3667, 507, 11, 46, "Print",ExpressionUUID->"3d26e66d-77db-4c99-afc1-fe08b76db0a8"],
Cell[165711, 3680, 314, 5, 46, "Print",ExpressionUUID->"fd5f8b16-eca4-42fe-9287-8d634455b5f6"],
Cell[166028, 3687, 317, 5, 46, "Print",ExpressionUUID->"1682e13d-8f01-4cf4-bf1f-057a3904e646"],
Cell[166348, 3694, 557, 13, 46, "Print",ExpressionUUID->"207f6ac5-09e2-4de6-a3b4-4e318e705241"],
Cell[166908, 3709, 433, 9, 46, "Print",ExpressionUUID->"f5e34511-7af9-49ff-bfe2-eba56872751d"],
Cell[167344, 3720, 313, 5, 46, "Print",ExpressionUUID->"0ac46dd9-5011-4d46-9d07-dbd05cc701d1"],
Cell[167660, 3727, 565, 13, 46, "Print",ExpressionUUID->"d044066a-1af7-43fa-b0eb-1b97b6b3d58f"]
}, Open  ]],
Cell[168240, 3743, 313, 4, 66, "Output",ExpressionUUID->"bcfe5a91-4fab-4170-a5d0-c072967cb915"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[168602, 3753, 385, 6, 106, "Subsection",ExpressionUUID->"67700722-0f36-af40-b3fb-8482efc23e9a"],
Cell[CellGroupData[{
Cell[169012, 3763, 4056, 98, 677, "Input",ExpressionUUID->"50e32df0-ccbf-a540-93b3-a8eb61b0c091"],
Cell[173071, 3863, 2158, 41, 672, "Output",ExpressionUUID->"d4fdf28a-77ac-46e0-93ef-09855e294f3e"],
Cell[175232, 3906, 563, 10, 66, "Output",ExpressionUUID->"fa9a14d6-921c-46a4-8408-373e9b3c7abd"],
Cell[CellGroupData[{
Cell[175820, 3920, 636, 13, 46, "Print",ExpressionUUID->"1f2cbd54-5970-47e5-8edc-859a8bbb2809"],
Cell[176459, 3935, 427, 8, 46, "Print",ExpressionUUID->"a5a2079b-c62b-4603-bdea-09c6d5468291"],
Cell[176889, 3945, 619, 13, 46, "Print",ExpressionUUID->"481625e1-d6c0-42c2-ab2b-b5e4a820ce6b"],
Cell[177511, 3960, 646, 13, 46, "Print",ExpressionUUID->"7c3280a5-6ca1-4787-a8d3-9bbe7983fa8b"],
Cell[178160, 3975, 625, 14, 46, "Print",ExpressionUUID->"6bb8d36e-87a6-4856-9b25-388fb8c564a8"],
Cell[178788, 3991, 437, 8, 46, "Print",ExpressionUUID->"a859e5cd-9f04-458e-92f3-ee71b302a752"],
Cell[179228, 4001, 438, 8, 46, "Print",ExpressionUUID->"f834dd25-fe40-4f1f-ac85-df2105294337"],
Cell[179669, 4011, 676, 16, 46, "Print",ExpressionUUID->"0c528580-00e6-4807-a372-37d9dbbacb64"],
Cell[180348, 4029, 555, 12, 46, "Print",ExpressionUUID->"3a93f1d7-7aa7-4a47-89f0-e6cd8293480b"],
Cell[180906, 4043, 434, 8, 46, "Print",ExpressionUUID->"1d6faf26-2682-4df2-82ca-13f06865a21e"],
Cell[181343, 4053, 688, 16, 46, "Print",ExpressionUUID->"c484d488-254e-4919-956f-a27ceb44043a"]
}, Open  ]],
Cell[182046, 4072, 443, 7, 66, "Output",ExpressionUUID->"3463adb1-d422-4bc2-ab5c-4ea7fbba8ab2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[182538, 4085, 374, 6, 106, "Subsection",ExpressionUUID->"45a86fcb-8a37-a848-a9e9-b490f25f1969"],
Cell[CellGroupData[{
Cell[182937, 4095, 3303, 81, 524, "Input",ExpressionUUID->"4cd313f8-c1f4-4649-a306-2f7c2d7acca0"],
Cell[186243, 4178, 1924, 38, 683, "Output",ExpressionUUID->"4dbec2e0-54f4-4ab2-bba9-35d151815c74"],
Cell[188170, 4218, 391, 7, 66, "Output",ExpressionUUID->"f50f2eb8-9a14-4555-b660-6bb7e7fa5e1c"],
Cell[CellGroupData[{
Cell[188586, 4229, 471, 10, 46, "Print",ExpressionUUID->"d26240d3-70a6-4400-8334-cb7b7c7af6b2"],
Cell[189060, 4241, 261, 5, 46, "Print",ExpressionUUID->"8f7bba26-fe99-4ef7-8b9c-aecc6c5853ef"],
Cell[189324, 4248, 454, 10, 46, "Print",ExpressionUUID->"95066ac7-d02f-44e3-b463-02e193ec4ea1"],
Cell[189781, 4260, 481, 10, 46, "Print",ExpressionUUID->"7171cd7a-b8f6-44cd-a931-d43ec59c4e91"],
Cell[190265, 4272, 461, 11, 46, "Print",ExpressionUUID->"cbf41dcb-a9ac-4b4b-8ec2-8ea7cb16a0cd"],
Cell[190729, 4285, 267, 5, 46, "Print",ExpressionUUID->"ca2f3cf8-c5e2-4a0e-91e1-2076e130cfbb"],
Cell[190999, 4292, 271, 5, 46, "Print",ExpressionUUID->"d762502d-7820-40f8-86c5-3b22eaa72207"],
Cell[191273, 4299, 511, 13, 46, "Print",ExpressionUUID->"166647d3-f355-4360-95cd-e5376af85bc1"],
Cell[191787, 4314, 390, 9, 46, "Print",ExpressionUUID->"313d2937-18cb-45df-a6df-d35977f6ef33"],
Cell[192180, 4325, 269, 5, 46, "Print",ExpressionUUID->"ecd6825a-7279-47c9-b7ce-299a22fc4556"],
Cell[192452, 4332, 523, 13, 46, "Print",ExpressionUUID->"a6c8dcb6-86a1-4a1c-b7b9-63ae486e99fd"]
}, Open  ]],
Cell[192990, 4348, 273, 4, 66, "Output",ExpressionUUID->"6a958d09-710c-4b81-9585-e448a24e4020"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[193312, 4358, 438, 7, 106, "Subsection",ExpressionUUID->"d31d0313-5114-fc44-9b6b-825cbaeedb98"],
Cell[CellGroupData[{
Cell[193775, 4369, 3431, 84, 565, "Input",ExpressionUUID->"d593ff76-d2b4-ac47-9d7e-50196d11175e"],
Cell[197209, 4455, 1976, 38, 683, "Output",ExpressionUUID->"111f7973-9424-4437-abe3-df59a7e69a2b"],
Cell[199188, 4495, 447, 10, 66, "Output",ExpressionUUID->"f8b9d007-f558-49da-8609-ec29eaa1ec5a"],
Cell[CellGroupData[{
Cell[199660, 4509, 471, 10, 46, "Print",ExpressionUUID->"9cd61970-7c30-4b71-8a67-3daff0b17cbc"],
Cell[200134, 4521, 262, 5, 46, "Print",ExpressionUUID->"a4db2395-9fc2-439d-8c19-c465931afcfc"],
Cell[200399, 4528, 451, 10, 46, "Print",ExpressionUUID->"3e8acbb1-6b4d-4a20-851b-580bc7254e84"],
Cell[200853, 4540, 481, 10, 46, "Print",ExpressionUUID->"7436fe6c-c024-49fc-874a-0e0841b4f0c9"],
Cell[201337, 4552, 461, 11, 46, "Print",ExpressionUUID->"5f41457f-3980-4c2c-af30-c1f795d54e18"],
Cell[201801, 4565, 268, 5, 46, "Print",ExpressionUUID->"c55c6159-97c2-4ceb-b6df-9d6a652cd762"],
Cell[202072, 4572, 269, 5, 46, "Print",ExpressionUUID->"5be09351-5869-497f-98e3-23a3e74a033e"],
Cell[202344, 4579, 511, 13, 46, "Print",ExpressionUUID->"14411204-faf1-4887-aa2a-85b75185a871"],
Cell[202858, 4594, 390, 9, 46, "Print",ExpressionUUID->"3313acc5-fafc-4c1f-8133-733ad4f8ebba"],
Cell[203251, 4605, 267, 5, 46, "Print",ExpressionUUID->"b70419f8-5de0-48de-938c-1cbf78f36fb2"],
Cell[203521, 4612, 523, 13, 46, "Print",ExpressionUUID->"7d96aeaf-407b-420a-8404-a86603557476"]
}, Open  ]],
Cell[204059, 4628, 270, 4, 66, "Output",ExpressionUUID->"4d35f5f2-1c8f-4427-98a8-0be49d034226"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[204378, 4638, 424, 6, 106, "Subsection",ExpressionUUID->"47d7cb90-9883-b44b-9a5f-d0586e618d19"],
Cell[CellGroupData[{
Cell[204827, 4648, 3706, 92, 606, "Input",ExpressionUUID->"a34d9bf1-5fa8-d146-b2e8-279225827a60"],
Cell[208536, 4742, 2090, 39, 742, "Output",ExpressionUUID->"399b9e4a-4e26-43ac-aa56-96e122309b00"],
Cell[210629, 4783, 365, 6, 66, "Output",ExpressionUUID->"16bfffb8-9594-452c-94e6-8c399098b5cd"],
Cell[CellGroupData[{
Cell[211019, 4793, 446, 9, 46, "Print",ExpressionUUID->"ed2ef6dc-4156-44a8-a9e7-e6b38d943eb1"],
Cell[211468, 4804, 236, 4, 46, "Print",ExpressionUUID->"17cd87a5-94f5-4346-b14e-2f397748f6fd"],
Cell[211707, 4810, 429, 9, 46, "Print",ExpressionUUID->"e3110ebc-b039-4e97-ae7b-57fa4baca41a"],
Cell[212139, 4821, 456, 9, 46, "Print",ExpressionUUID->"147713f1-7bad-483e-b3db-c14026a487ea"],
Cell[212598, 4832, 436, 10, 46, "Print",ExpressionUUID->"f96ad9bd-134f-4fca-83bc-c1df9cea948e"],
Cell[213037, 4844, 247, 4, 46, "Print",ExpressionUUID->"0fa2643e-9c74-4c63-bb25-43a19fb1f10a"],
Cell[213287, 4850, 246, 4, 46, "Print",ExpressionUUID->"47d47857-7a10-488f-a16d-5d56ff52eec2"],
Cell[213536, 4856, 487, 12, 46, "Print",ExpressionUUID->"818ce0e4-e299-4682-b0d7-5c37d06550e7"],
Cell[214026, 4870, 366, 8, 46, "Print",ExpressionUUID->"288bbe2d-5900-42e8-a77e-b5f0bcde8520"],
Cell[214395, 4880, 244, 4, 46, "Print",ExpressionUUID->"104d9ca5-d178-4ea7-89f1-f23b6d808d3e"],
Cell[214642, 4886, 500, 12, 46, "Print",ExpressionUUID->"f8bb0c56-47e5-4788-b791-5313ef72d457"]
}, Open  ]],
Cell[215157, 4901, 246, 3, 66, "Output",ExpressionUUID->"c95ba954-e214-4ba4-95bb-ac3995753151"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[215452, 4910, 573, 10, 106, "Subsection",ExpressionUUID->"ac87a7d0-47c4-ba43-9f38-d7942f291ff6"],
Cell[CellGroupData[{
Cell[216050, 4924, 2870, 72, 565, "Input",ExpressionUUID->"d9040454-3060-ec46-abec-d61346bf96a3"],
Cell[218923, 4998, 1967, 38, 662, "Output",ExpressionUUID->"1fd72677-5f4b-4dda-8dea-eb94ab0b2b90"],
Cell[220893, 5038, 445, 10, 66, "Output",ExpressionUUID->"45db458e-bf5e-4a8c-9840-f523919ac9e8"],
Cell[CellGroupData[{
Cell[221363, 5052, 518, 11, 46, "Print",ExpressionUUID->"a08c5e6d-f4c4-445a-81d5-d89e00455c2c"],
Cell[221884, 5065, 309, 6, 46, "Print",ExpressionUUID->"06ff0df4-e1fd-4802-a45f-2abf3983aed8"],
Cell[222196, 5073, 501, 11, 46, "Print",ExpressionUUID->"182fd81a-7e52-470c-8a54-0dd1a7fb24ad"],
Cell[222700, 5086, 530, 11, 46, "Print",ExpressionUUID->"1391fc65-9b77-45d0-b00c-3fd2a9f4a392"],
Cell[223233, 5099, 508, 12, 46, "Print",ExpressionUUID->"5702d556-989c-42aa-a8df-9424fc9dbf5c"],
Cell[223744, 5113, 317, 6, 46, "Print",ExpressionUUID->"5902c4d5-29d8-4739-aa1f-addde80d4e41"],
Cell[224064, 5121, 318, 6, 46, "Print",ExpressionUUID->"9ccfb7bb-5b89-4c44-8e81-d3f1958ca4c7"],
Cell[224385, 5129, 562, 14, 46, "Print",ExpressionUUID->"925fdaa7-d8dd-46cb-abc7-c87dc91d2d17"],
Cell[224950, 5145, 441, 10, 46, "Print",ExpressionUUID->"f16db894-bbfd-4dcf-9c82-652bcbfe51d2"],
Cell[225394, 5157, 310, 5, 46, "Print",ExpressionUUID->"3bd646ff-d8a4-46be-a46f-3521da557de5"],
Cell[225707, 5164, 566, 13, 46, "Print",ExpressionUUID->"f4f573a2-17bb-4067-8874-cb4692295a17"]
}, Open  ]],
Cell[226288, 5180, 321, 5, 66, "Output",ExpressionUUID->"326cb1c4-4ddb-457a-af67-98c624299b95"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[226658, 5191, 475, 7, 106, "Subsection",ExpressionUUID->"4b709e95-6340-644c-a84a-6656f3603403"],
Cell[CellGroupData[{
Cell[227158, 5202, 3775, 90, 647, "Input",ExpressionUUID->"eeb0b29a-10f3-2241-b71d-46c2445c754e"],
Cell[230936, 5294, 2243, 44, 864, "Output",ExpressionUUID->"82401e4b-1bea-443d-948e-9e309c65535a"],
Cell[233182, 5340, 633, 13, 66, "Output",ExpressionUUID->"bca64907-bc8f-433b-803c-d99b84b35b05"],
Cell[CellGroupData[{
Cell[233840, 5357, 715, 14, 46, "Print",ExpressionUUID->"c1704990-1e5c-4b37-b776-2e2286f21f1b"],
Cell[234558, 5373, 506, 9, 46, "Print",ExpressionUUID->"c7d4bede-e133-40ad-a92d-5ddc5b0a9140"],
Cell[235067, 5384, 698, 14, 46, "Print",ExpressionUUID->"ade858b4-b834-4b6b-8511-3387db892499"],
Cell[235768, 5400, 725, 14, 46, "Print",ExpressionUUID->"b6094867-98fd-492d-b1c8-cdf4f0a19cb0"],
Cell[236496, 5416, 705, 15, 46, "Print",ExpressionUUID->"ee71277e-b959-45c7-aa87-8c648e7b33d9"],
Cell[237204, 5433, 514, 9, 46, "Print",ExpressionUUID->"edda51a4-1863-4276-a8ca-9a76f331d1de"],
Cell[237721, 5444, 515, 9, 46, "Print",ExpressionUUID->"5c7737c6-69d2-4d7f-8db7-a1d01fac4685"],
Cell[238239, 5455, 756, 17, 46, "Print",ExpressionUUID->"2b65319c-759e-49f8-a182-fe1aad0e571c"],
Cell[238998, 5474, 635, 13, 46, "Print",ExpressionUUID->"e65e82a2-a870-415d-b4ae-912dc0060479"],
Cell[239636, 5489, 512, 9, 46, "Print",ExpressionUUID->"f2f91b1b-1369-4af0-93d8-08480baa8007"],
Cell[240151, 5500, 769, 17, 46, "Print",ExpressionUUID->"f2159653-ff41-486a-9dd4-955cf86785a7"]
}, Open  ]],
Cell[240935, 5520, 516, 9, 66, "Output",ExpressionUUID->"623f54b9-a34d-4069-9d6e-bf8ab2ba1644"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[241500, 5535, 473, 7, 106, "Subsection",ExpressionUUID->"f97493c9-2e91-446e-b310-f58f5aeadca9"],
Cell[CellGroupData[{
Cell[241998, 5546, 3858, 100, 677, "Input",ExpressionUUID->"3bdc12d9-4db7-40bf-bc39-30cdb73b7340"],
Cell[245859, 5648, 2264, 43, 1043, "Output",ExpressionUUID->"1a4fc75d-12c7-449c-ac5b-323cc7b18888"],
Cell[248126, 5693, 612, 12, 66, "Output",ExpressionUUID->"5e13edbf-4513-46ef-a6df-c5e463678854"],
Cell[CellGroupData[{
Cell[248763, 5709, 677, 13, 46, "Print",ExpressionUUID->"1ed12a93-b868-4567-9176-5076409d9255"],
Cell[249443, 5724, 470, 8, 46, "Print",ExpressionUUID->"f5d0cc4c-6508-42dc-a4b4-61ca68093a29"],
Cell[249916, 5734, 660, 13, 46, "Print",ExpressionUUID->"a51d6856-73f2-4296-b177-5bb7b7190d99"],
Cell[250579, 5749, 687, 13, 46, "Print",ExpressionUUID->"2f5c3bef-22e9-4705-b164-79835d19558b"],
Cell[251269, 5764, 667, 14, 46, "Print",ExpressionUUID->"d79d2acc-f272-42ab-b5d7-36a66bf32ab2"],
Cell[251939, 5780, 478, 8, 46, "Print",ExpressionUUID->"a1dab5f6-0155-49e4-9ea8-4d38c3527728"],
Cell[252420, 5790, 477, 8, 46, "Print",ExpressionUUID->"45948d31-9297-447a-b3db-3c14f0fe1089"],
Cell[252900, 5800, 719, 16, 46, "Print",ExpressionUUID->"0443a5d9-feff-4c16-8b17-b9e70fb1836f"],
Cell[253622, 5818, 598, 12, 46, "Print",ExpressionUUID->"e0d7dff8-6847-4ce1-bad6-cbf09b4418d8"],
Cell[254223, 5832, 477, 8, 46, "Print",ExpressionUUID->"1cb994b6-b4f2-4aa9-b3e1-b737c753fd80"],
Cell[254703, 5842, 731, 16, 46, "Print",ExpressionUUID->"ce20512c-e4ff-4a91-afaf-05063e83952f"]
}, Open  ]],
Cell[255449, 5861, 488, 8, 66, "Output",ExpressionUUID->"7585a43a-6775-4fd2-8279-850397a9a3c4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[255986, 5875, 480, 7, 106, "Subsection",ExpressionUUID->"f439aa4f-213c-bf40-838a-258ab3e0ddf4"],
Cell[CellGroupData[{
Cell[256491, 5886, 3101, 80, 606, "Input",ExpressionUUID->"63917b59-f2bb-e04b-8d06-bf7075a4cf42"],
Cell[259595, 5968, 1986, 38, 936, "Output",ExpressionUUID->"77b3d290-25d6-45ff-84de-a3353146c021"],
Cell[261584, 6008, 450, 8, 66, "Output",ExpressionUUID->"b0e08cf1-23dd-4e5d-9dce-ea7762d3929f"],
Cell[CellGroupData[{
Cell[262059, 6020, 515, 10, 46, "Print",ExpressionUUID->"6a9e247d-322e-4ee3-8607-4a2ead686eb8"],
Cell[262577, 6032, 309, 5, 46, "Print",ExpressionUUID->"ef7ff8e8-9a4d-4fee-a89e-78bf557908b9"],
Cell[262889, 6039, 499, 10, 46, "Print",ExpressionUUID->"473bb009-e8ca-4b65-a803-d0219c16f840"],
Cell[263391, 6051, 526, 10, 46, "Print",ExpressionUUID->"c3083ae6-cc93-4f6c-ae06-713853a95147"],
Cell[263920, 6063, 506, 11, 46, "Print",ExpressionUUID->"b9107fc4-3083-45af-a8fe-bd709a0932d8"],
Cell[264429, 6076, 317, 5, 46, "Print",ExpressionUUID->"dd4625e8-2a69-47ad-8a53-82134ede24ba"],
Cell[264749, 6083, 318, 5, 46, "Print",ExpressionUUID->"bfd3c450-04e2-48c4-b8e9-89ff2819b79a"],
Cell[265070, 6090, 560, 13, 46, "Print",ExpressionUUID->"fdc46f65-6002-40b4-8daa-2cb86af387c6"],
Cell[265633, 6105, 437, 9, 46, "Print",ExpressionUUID->"6b18586b-7d97-4197-95d6-9418c6f36c91"],
Cell[266073, 6116, 314, 5, 46, "Print",ExpressionUUID->"9da3c059-e040-4d78-95f7-e59bda1872d8"],
Cell[266390, 6123, 569, 13, 46, "Print",ExpressionUUID->"abfaa41f-d1f6-4b7b-bc22-eb4e937b04db"]
}, Open  ]],
Cell[266974, 6139, 325, 5, 66, "Output",ExpressionUUID->"616900a8-4518-42a1-ae21-58011c832813"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[267348, 6150, 511, 7, 106, "Subsection",ExpressionUUID->"0827ab51-42ca-4a18-8ea3-ad0d9d46eda9"],
Cell[CellGroupData[{
Cell[267884, 6161, 2865, 75, 606, "Input",ExpressionUUID->"0b60f958-d4ed-4ad3-b140-de55463d88a7"],
Cell[270752, 6238, 1937, 38, 936, "Output",ExpressionUUID->"5b623605-05fb-4b9e-94d2-101fd2a64b62"],
Cell[272692, 6278, 392, 8, 66, "Output",ExpressionUUID->"1df29d1c-8489-4293-90c4-6b99f718766d"],
Cell[CellGroupData[{
Cell[273109, 6290, 474, 10, 46, "Print",ExpressionUUID->"0fbf6f98-e9b1-46b0-9a9c-bd1d661b3841"],
Cell[273586, 6302, 267, 5, 46, "Print",ExpressionUUID->"e79f2698-2943-43cd-ba1f-89b85e4dc784"],
Cell[273856, 6309, 455, 10, 46, "Print",ExpressionUUID->"4fa37917-3143-4ba9-9efa-5c4f3f2d0643"],
Cell[274314, 6321, 486, 10, 46, "Print",ExpressionUUID->"f00501b7-7ec4-417a-ab12-51eec17a61a5"],
Cell[274803, 6333, 464, 11, 46, "Print",ExpressionUUID->"04655ab0-c7c6-4955-88c5-a9368d0a253d"],
Cell[275270, 6346, 273, 5, 46, "Print",ExpressionUUID->"3119bdd5-bafd-486e-8932-a33eda65b954"],
Cell[275546, 6353, 274, 5, 46, "Print",ExpressionUUID->"9000e6e5-1f2e-4944-96c0-bdaea51609e2"],
Cell[275823, 6360, 518, 13, 46, "Print",ExpressionUUID->"8bc875b4-b3a8-4927-9808-f5912af3b93e"],
Cell[276344, 6375, 395, 9, 46, "Print",ExpressionUUID->"fea925e2-0750-41f8-baa7-d8b5d2eb48bc"],
Cell[276742, 6386, 272, 5, 46, "Print",ExpressionUUID->"10ba6fbf-f4d8-409f-8e63-6c14cdcf9862"],
Cell[277017, 6393, 530, 13, 46, "Print",ExpressionUUID->"ebf77eb5-27ce-4659-af6f-e374e082ed82"]
}, Open  ]],
Cell[277562, 6409, 275, 5, 66, "Output",ExpressionUUID->"c36c15ad-7b93-47cc-b4fe-bfc857b9c204"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[277886, 6420, 494, 7, 106, "Subsection",ExpressionUUID->"796948fb-98b5-154f-a5b7-3183bd6bb814"],
Cell[CellGroupData[{
Cell[278405, 6431, 3105, 79, 677, "Input",ExpressionUUID->"73599b1d-5ca8-ad4c-90de-1bb65ce31008"],
Cell[281513, 6512, 1966, 38, 663, "Output",ExpressionUUID->"989461ab-1ac7-4954-b7b0-2c693620a1ae"],
Cell[283482, 6552, 371, 7, 66, "Output",ExpressionUUID->"f718e34f-2d96-4a7a-a696-f832db25e217"],
Cell[CellGroupData[{
Cell[283878, 6563, 447, 9, 46, "Print",ExpressionUUID->"df359fb0-9e61-451b-b57f-3c39cc5f7900"],
Cell[284328, 6574, 238, 4, 46, "Print",ExpressionUUID->"a13b6d6b-7f1d-4b42-a665-75db4cad25b8"],
Cell[284569, 6580, 430, 9, 46, "Print",ExpressionUUID->"c1ab11d8-ecdc-4ef4-b084-e288ef01b5b0"],
Cell[285002, 6591, 457, 9, 46, "Print",ExpressionUUID->"50a69e54-1584-4bb0-991b-f7398e2f1ae5"],
Cell[285462, 6602, 437, 10, 46, "Print",ExpressionUUID->"33c4d6c7-0acd-4a1a-82e6-e05bd7dc044d"],
Cell[285902, 6614, 246, 4, 46, "Print",ExpressionUUID->"6ffb9a6c-e0bb-470a-9663-d408f3d35f5e"],
Cell[286151, 6620, 247, 4, 46, "Print",ExpressionUUID->"c9a2e1df-2b8f-4a8b-ab1f-29c1556a5922"],
Cell[286401, 6626, 489, 12, 46, "Print",ExpressionUUID->"c639ab08-bed3-465b-8bc1-56be2df3e6ff"],
Cell[286893, 6640, 368, 8, 46, "Print",ExpressionUUID->"a88e4a18-d1ba-4cef-be1f-9e4014685609"],
Cell[287264, 6650, 245, 4, 46, "Print",ExpressionUUID->"61fa771d-1184-4c33-90b6-5b17e487910c"],
Cell[287512, 6656, 503, 12, 46, "Print",ExpressionUUID->"0c22fb97-fe65-4b3c-a5b3-c7f7c45724f9"]
}, Open  ]],
Cell[288030, 6671, 250, 4, 66, "Output",ExpressionUUID->"36d8d207-282b-4d28-ba2c-74d72dddca95"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[288329, 6681, 579, 8, 106, "Subsection",ExpressionUUID->"0e0f1352-33a7-2d43-a0e0-4f4a8a625eb1"],
Cell[CellGroupData[{
Cell[288933, 6693, 3252, 80, 647, "Input",ExpressionUUID->"4e293b0a-1820-5c41-a2d6-6c0042da2ec8"],
Cell[292188, 6775, 2112, 41, 653, "Output",ExpressionUUID->"5ee138a4-ebe4-4dfb-86ff-0fb51d62580a"],
Cell[294303, 6818, 538, 10, 66, "Output",ExpressionUUID->"a54879a2-8b04-4b77-bc5b-dbd419234c52"],
Cell[CellGroupData[{
Cell[294866, 6832, 615, 12, 46, "Print",ExpressionUUID->"6b00fceb-0b83-4155-9275-f6bcf3770e2b"],
Cell[295484, 6846, 408, 7, 46, "Print",ExpressionUUID->"3fffc3de-4c50-439a-8b89-9db14c97ef69"],
Cell[295895, 6855, 600, 12, 46, "Print",ExpressionUUID->"ec7f9347-2f94-4600-b4ff-455d79629912"],
Cell[296498, 6869, 627, 12, 46, "Print",ExpressionUUID->"55eb5783-c3e1-4c09-88c9-2ef4d7c2c58a"],
Cell[297128, 6883, 605, 13, 46, "Print",ExpressionUUID->"f5567689-f8b1-421a-92f5-51542ac76573"],
Cell[297736, 6898, 414, 7, 46, "Print",ExpressionUUID->"6fbef2be-39e1-4612-969d-c7aa6a1a1d46"],
Cell[298153, 6907, 414, 7, 46, "Print",ExpressionUUID->"09e82418-7dc5-4dac-b3a3-8383ddd14b88"],
Cell[298570, 6916, 657, 15, 46, "Print",ExpressionUUID->"13aa9bd6-8e22-44db-b71a-f4160403e396"],
Cell[299230, 6933, 536, 11, 46, "Print",ExpressionUUID->"be32dcca-4412-4e33-84e4-c5bbd902064b"],
Cell[299769, 6946, 413, 7, 46, "Print",ExpressionUUID->"400c6954-fc46-41eb-a128-ad34b0da577b"],
Cell[300185, 6955, 671, 15, 46, "Print",ExpressionUUID->"0dacaeb7-a8dc-4da8-a6c1-aa2692e1eeb9"]
}, Open  ]],
Cell[300871, 6973, 419, 7, 66, "Output",ExpressionUUID->"76860c4b-41fc-4f06-badf-59672b225d71"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[301339, 6986, 518, 7, 106, "Subsection",ExpressionUUID->"f1e1f7b4-6347-3642-8b51-66409ae18429"],
Cell[CellGroupData[{
Cell[301882, 6997, 3852, 102, 707, "Input",ExpressionUUID->"ec25f39e-6c0f-6242-83c1-cdcc9f61ea90"],
Cell[305737, 7101, 2089, 41, 653, "Output",ExpressionUUID->"0b955fe3-35ff-4d4e-8233-b69dffc69935"],
Cell[307829, 7144, 441, 9, 66, "Output",ExpressionUUID->"3b810996-40c4-49c1-834b-485c62be07dc"],
Cell[CellGroupData[{
Cell[308295, 7157, 494, 10, 46, "Print",ExpressionUUID->"6e00380b-ca74-4f2c-9a25-628306eb1c2c"],
Cell[308792, 7169, 287, 5, 46, "Print",ExpressionUUID->"d3afea3a-aace-4885-9f40-293898647eb2"],
Cell[309082, 7176, 477, 10, 46, "Print",ExpressionUUID->"0ae354d5-d1db-4b53-88e9-ddaa4ae34e34"],
Cell[309562, 7188, 504, 10, 46, "Print",ExpressionUUID->"efdd41c5-d064-420b-9b86-7274c8f38a04"],
Cell[310069, 7200, 484, 11, 46, "Print",ExpressionUUID->"c813b1e3-99ea-40ba-9982-d9e4ad5b6e77"],
Cell[310556, 7213, 293, 5, 46, "Print",ExpressionUUID->"a403f14a-d18e-41d1-aeee-0e17d59d8802"],
Cell[310852, 7220, 294, 5, 46, "Print",ExpressionUUID->"460f9c9f-6f5c-48ea-8760-c6a8084458e0"],
Cell[311149, 7227, 538, 13, 46, "Print",ExpressionUUID->"420c1c76-4cc0-4891-b777-8f028e8907a7"],
Cell[311690, 7242, 415, 9, 46, "Print",ExpressionUUID->"f71a99ff-62ff-4f73-bd2f-3d6213780e1e"],
Cell[312108, 7253, 294, 5, 46, "Print",ExpressionUUID->"7a86f73a-67b8-4a42-99fa-2403af1d3b09"],
Cell[312405, 7260, 548, 13, 46, "Print",ExpressionUUID->"ffcbabf1-fb5e-4813-827e-39340df6a240"]
}, Open  ]],
Cell[312968, 7276, 299, 5, 66, "Output",ExpressionUUID->"304e0a2b-eafb-4137-833a-3ebde6bcdb8e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[313316, 7287, 611, 9, 106, "Subsection",ExpressionUUID->"684ea65d-51eb-4522-b2f9-96b8c6a91943"],
Cell[CellGroupData[{
Cell[313952, 7300, 7243, 199, 1415, "Input",ExpressionUUID->"84ad1fe5-e1c6-4225-9256-9c76a02acd42"],
Cell[321198, 7501, 2552, 50, 683, "Output",ExpressionUUID->"e98d64b5-60f3-4bdd-8f81-197f33ef1efe"],
Cell[323753, 7553, 459, 10, 66, "Output",ExpressionUUID->"d83e9ebd-6780-464f-91cb-c8f31f780fe9"],
Cell[CellGroupData[{
Cell[324237, 7567, 470, 10, 46, "Print",ExpressionUUID->"42099912-d998-452c-8fe7-44fbe43bc2c6"],
Cell[324710, 7579, 261, 5, 46, "Print",ExpressionUUID->"84410568-f5b8-487d-8993-69afb46b034e"],
Cell[324974, 7586, 453, 10, 46, "Print",ExpressionUUID->"7be9a1a9-de22-454b-aa5b-404c21157afe"],
Cell[325430, 7598, 480, 10, 46, "Print",ExpressionUUID->"00ca63bc-1faa-48d0-9e5e-bf5432b305ce"],
Cell[325913, 7610, 460, 11, 46, "Print",ExpressionUUID->"006dfab3-983e-45d3-b733-7377a80bcc50"],
Cell[326376, 7623, 269, 5, 46, "Print",ExpressionUUID->"72f71e39-748a-4151-a777-64d4da45edce"],
Cell[326648, 7630, 272, 5, 46, "Print",ExpressionUUID->"399cc6a6-2cd6-4c6e-ac20-f15dcc3e1aa1"],
Cell[326923, 7637, 512, 13, 46, "Print",ExpressionUUID->"9389468d-8b1e-4c52-bea0-e2eb620252da"],
Cell[327438, 7652, 391, 9, 46, "Print",ExpressionUUID->"9c401af6-d083-4bdf-af78-529d139b8d38"],
Cell[327832, 7663, 267, 5, 46, "Print",ExpressionUUID->"7226a89e-1cc5-4332-b18e-5e97a469bc32"],
Cell[328102, 7670, 524, 13, 46, "Print",ExpressionUUID->"bd661f0b-095a-485a-a58e-1d56202b4887"]
}, Open  ]],
Cell[328641, 7686, 295, 5, 66, "Output",ExpressionUUID->"8c054090-d749-4622-a023-a80df81cb328"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

